/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.event;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.query.IListQuery;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.query.dsl.ConditionDsl;
import me.ahoo.wow.query.dsl.DslKt;
import me.ahoo.wow.query.dsl.ListQueryDsl;
import me.ahoo.wow.query.event.filter.EventStreamQueryHandler;
import me.ahoo.wow.webflux.exception.RequestExceptionHandler;
import me.ahoo.wow.webflux.route.ResponsesKt;
import me.ahoo.wow.webflux.route.command.AggregateRequestKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/ahoo/wow/webflux/route/event/LoadEventStreamHandlerFunction;", "Lorg/springframework/web/reactive/function/server/HandlerFunction;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "eventStreamQueryHandler", "Lme/ahoo/wow/query/event/filter/EventStreamQueryHandler;", "exceptionHandler", "Lme/ahoo/wow/webflux/exception/RequestExceptionHandler;", "<init>", "(Lme/ahoo/wow/modeling/matedata/AggregateMetadata;Lme/ahoo/wow/query/event/filter/EventStreamQueryHandler;Lme/ahoo/wow/webflux/exception/RequestExceptionHandler;)V", "handle", "Lreactor/core/publisher/Mono;", "request", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "wow-webflux"})
public final class LoadEventStreamHandlerFunction
implements HandlerFunction<ServerResponse> {
    @NotNull
    private final AggregateMetadata<?, ?> aggregateMetadata;
    @NotNull
    private final EventStreamQueryHandler eventStreamQueryHandler;
    @NotNull
    private final RequestExceptionHandler exceptionHandler;

    public LoadEventStreamHandlerFunction(@NotNull AggregateMetadata<?, ?> aggregateMetadata, @NotNull EventStreamQueryHandler eventStreamQueryHandler, @NotNull RequestExceptionHandler exceptionHandler) {
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        Intrinsics.checkNotNullParameter((Object)eventStreamQueryHandler, (String)"eventStreamQueryHandler");
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        this.aggregateMetadata = aggregateMetadata;
        this.eventStreamQueryHandler = eventStreamQueryHandler;
        this.exceptionHandler = exceptionHandler;
    }

    @NotNull
    public Mono<ServerResponse> handle(@NotNull ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String tenantId = AggregateRequestKt.getTenantIdOrDefault(request, this.aggregateMetadata);
        String string = request.pathVariable("id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathVariable(...)");
        String id = string;
        String string2 = request.pathVariable("headVersion");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathVariable(...)");
        int headVersion = Integer.parseInt(string2);
        String string3 = request.pathVariable("tailVersion");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pathVariable(...)");
        int tailVersion = Integer.parseInt(string3);
        int limit = tailVersion - headVersion + 1;
        IListQuery listQuery = DslKt.listQuery(arg_0 -> LoadEventStreamHandlerFunction.handle$lambda$1(limit, tenantId, id, headVersion, tailVersion, arg_0));
        Mono mono = this.eventStreamQueryHandler.dynamicList((NamedAggregate)this.aggregateMetadata, listQuery).collectList();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"collectList(...)");
        return ResponsesKt.toServerResponse(mono, request, this.exceptionHandler);
    }

    private static final Unit handle$lambda$1$lambda$0(String $tenantId, String $id, int $headVersion, int $tailVersion, ConditionDsl $this$condition) {
        Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$this$condition");
        $this$condition.tenantId($tenantId);
        $this$condition.eq("aggregateId", (Object)$id);
        $this$condition.to($this$condition.between("version", (Object)$headVersion), (Object)$tailVersion);
        return Unit.INSTANCE;
    }

    private static final Unit handle$lambda$1(int $limit, String $tenantId, String $id, int $headVersion, int $tailVersion, ListQueryDsl $this$listQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$listQuery, (String)"$this$listQuery");
        $this$listQuery.condition(arg_0 -> LoadEventStreamHandlerFunction.handle$lambda$1$lambda$0($tenantId, $id, $headVersion, $tailVersion, arg_0));
        $this$listQuery.limit($limit);
        return Unit.INSTANCE;
    }
}

