/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.exception;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import me.ahoo.wow.api.exception.ErrorInfo;
import me.ahoo.wow.exception.WowExceptionKt;
import me.ahoo.wow.serialization.JsonSerializerKt;
import me.ahoo.wow.webflux.exception.ErrorHttpStatusMapping;
import me.ahoo.wow.webflux.exception.GlobalExceptionHandlerKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.validation.BindingResult;
import org.springframework.web.method.annotation.HandlerMethodValidationException;
import org.springframework.web.reactive.resource.NoResourceFoundException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0018\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0015"}, d2={"Lme/ahoo/wow/webflux/exception/GlobalExceptionHandler;", "Lorg/springframework/web/server/WebExceptionHandler;", "Lorg/springframework/core/Ordered;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "handle", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "exchange", "Lorg/springframework/web/server/ServerWebExchange;", "ex", "", "formatRequest", "", "Lorg/springframework/http/server/reactive/ServerHttpRequest;", "getOrder", "", "wow-webflux"})
public final class GlobalExceptionHandler
implements WebExceptionHandler,
Ordered {
    @NotNull
    public static final GlobalExceptionHandler INSTANCE = new GlobalExceptionHandler();
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    private GlobalExceptionHandler() {
    }

    @NotNull
    public Mono<Void> handle(@NotNull ServerWebExchange exchange, @NotNull Throwable ex) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        if (log.isWarnEnabled()) {
            ServerHttpRequest serverHttpRequest = exchange.getRequest();
            Intrinsics.checkNotNullExpressionValue((Object)serverHttpRequest, (String)"getRequest(...)");
            log.warn(this.formatRequest(serverHttpRequest), ex);
        }
        ErrorInfo errorInfo = (throwable = ex) instanceof HandlerMethodValidationException ? GlobalExceptionHandlerKt.toBindingErrorInfo((HandlerMethodValidationException)ex) : (throwable instanceof BindingResult ? GlobalExceptionHandlerKt.toBindingErrorInfo((BindingResult)ex) : (throwable instanceof NoResourceFoundException ? ErrorInfo.Companion.of$default((ErrorInfo.Companion)ErrorInfo.Companion, (String)"NotFound", (String)((NoResourceFoundException)ex).getMessage(), null, (int)4, null) : WowExceptionKt.toErrorInfo((Throwable)ex)));
        HttpStatus status = ErrorHttpStatusMapping.toHttpStatus$default(ErrorHttpStatusMapping.INSTANCE, errorInfo, null, 1, null);
        ServerHttpResponse serverHttpResponse = exchange.getResponse();
        Intrinsics.checkNotNullExpressionValue((Object)serverHttpResponse, (String)"getResponse(...)");
        ServerHttpResponse response = serverHttpResponse;
        response.setStatusCode((HttpStatusCode)status);
        response.getHeaders().set("Wow-Error-Code", errorInfo.getErrorCode());
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        DataBufferFactory dataBufferFactory = response.bufferFactory();
        String string = JsonSerializerKt.toJsonString((Object)errorInfo);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Mono mono = response.writeWith((Publisher)Mono.just((Object)dataBufferFactory.wrap(byArray)));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"writeWith(...)");
        return mono;
    }

    @NotNull
    public final String formatRequest(@NotNull ServerHttpRequest $this$formatRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$formatRequest, (String)"<this>");
        return "HTTP " + $this$formatRequest.getMethod() + " " + $this$formatRequest.getURI();
    }

    public int getOrder() {
        return -2;
    }
}

