/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.command;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandResult;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.WaitStrategy;
import me.ahoo.wow.command.wait.WaitingFor;
import me.ahoo.wow.openapi.route.AggregateRouteMetadata;
import me.ahoo.wow.webflux.route.command.AggregateRequestKt;
import me.ahoo.wow.webflux.route.command.CommandHandlerFunctionKt;
import me.ahoo.wow.webflux.route.command.CommandMessageParser;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/ahoo/wow/webflux/route/command/CommandHandler;", "", "commandGateway", "Lme/ahoo/wow/command/CommandGateway;", "commandMessageParser", "Lme/ahoo/wow/webflux/route/command/CommandMessageParser;", "timeout", "Ljava/time/Duration;", "<init>", "(Lme/ahoo/wow/command/CommandGateway;Lme/ahoo/wow/webflux/route/command/CommandMessageParser;Ljava/time/Duration;)V", "handle", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/command/CommandResult;", "request", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "commandBody", "aggregateRouteMetadata", "Lme/ahoo/wow/openapi/route/AggregateRouteMetadata;", "sendCommand", "commandMessage", "Lme/ahoo/wow/api/command/CommandMessage;", "wow-webflux"})
public final class CommandHandler {
    @NotNull
    private final CommandGateway commandGateway;
    @NotNull
    private final CommandMessageParser commandMessageParser;
    @NotNull
    private final Duration timeout;

    public CommandHandler(@NotNull CommandGateway commandGateway, @NotNull CommandMessageParser commandMessageParser, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)commandGateway, (String)"commandGateway");
        Intrinsics.checkNotNullParameter((Object)commandMessageParser, (String)"commandMessageParser");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.commandGateway = commandGateway;
        this.commandMessageParser = commandMessageParser;
        this.timeout = timeout;
    }

    public /* synthetic */ CommandHandler(CommandGateway commandGateway, CommandMessageParser commandMessageParser, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            duration = CommandHandlerFunctionKt.getDEFAULT_TIME_OUT();
        }
        this(commandGateway, commandMessageParser, duration);
    }

    @NotNull
    public final Mono<CommandResult> handle(@NotNull ServerRequest request, @NotNull Object commandBody, @NotNull AggregateRouteMetadata<?> aggregateRouteMetadata) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)commandBody, (String)"commandBody");
        Intrinsics.checkNotNullParameter(aggregateRouteMetadata, (String)"aggregateRouteMetadata");
        Duration commandWaitTimeout = AggregateRequestKt.getWaitTimeout(request, this.timeout);
        Mono mono = this.commandMessageParser.parse(aggregateRouteMetadata, commandBody, request).flatMap(arg_0 -> CommandHandler.handle$lambda$1(arg_0 -> CommandHandler.handle$lambda$0(this, request, commandWaitTimeout, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    private final Mono<CommandResult> sendCommand(CommandMessage<Object> commandMessage, ServerRequest request) {
        CharSequence charSequence;
        CommandStage stage = AggregateRequestKt.getCommandStage(request);
        if (commandMessage.isVoid() || CommandStage.SENT == stage) {
            return this.commandGateway.sendAndWaitForSent(commandMessage);
        }
        CharSequence charSequence2 = AggregateRequestKt.getWaitContext(request);
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = commandMessage.getContextName();
        } else {
            charSequence = charSequence2;
        }
        String waitContext = (String)charSequence;
        return this.commandGateway.sendAndWait(commandMessage, (WaitStrategy)WaitingFor.Companion.stage(stage, waitContext, AggregateRequestKt.getWaitProcessor(request)));
    }

    private static final Mono handle$lambda$0(CommandHandler this$0, ServerRequest $request, Duration $commandWaitTimeout, CommandMessage it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.sendCommand((CommandMessage<Object>)it, $request).timeout($commandWaitTimeout);
    }

    private static final Mono handle$lambda$1(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }
}

