/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.command;

import java.time.Duration;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.annotation.AggregateRoute;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.messaging.function.NamedFunctionInfoData;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.WaitStrategy;
import me.ahoo.wow.command.wait.chain.SimpleWaitingForChain;
import me.ahoo.wow.command.wait.stage.WaitingForStage;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.webflux.route.command.CommandHandlerFunctionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.ServerRequest;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u001e\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0011\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0002\u00a2\u0006\u0002\u0010\r\u001a\n\u0010\u000e\u001a\u00020\f*\u00020\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0017\u001a\u0004\u0018\u00010\u0013*\u00020\u0002\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u001c*\u00020\u00022\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a8\u0006 "}, d2={"getTenantId", "", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "getOwnerId", "getTenantIdOrDefault", "getAggregateId", "owner", "Lme/ahoo/wow/api/annotation/AggregateRoute$Owner;", "ownerId", "getLocalFirst", "", "(Lorg/springframework/web/reactive/function/server/ServerRequest;)Ljava/lang/Boolean;", "isSse", "getWaitTimeout", "Ljava/time/Duration;", "default", "getWaitStage", "Lme/ahoo/wow/command/wait/CommandStage;", "getWaitContext", "getWaitProcessor", "getWaitFunction", "getWaitTailStage", "getWaitTailContext", "getWaitTailProcessor", "getWaitTailFunction", "extractWaitStrategy", "Lme/ahoo/wow/command/wait/WaitStrategy;", "commandMessage", "Lme/ahoo/wow/api/command/CommandMessage;", "", "wow-webflux"})
@SourceDebugExtension(value={"SMAP\nAggregateRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AggregateRequest.kt\nme/ahoo/wow/webflux/route/command/AggregateRequestKt\n+ 2 Strings.kt\nme/ahoo/wow/infra/StringsKt\n*L\n1#1,176:1\n17#2,4:177\n17#2,4:181\n17#2,4:185\n17#2,4:189\n17#2,4:193\n17#2,4:197\n17#2,4:201\n17#2,4:205\n17#2,4:209\n17#2,4:213\n*S KotlinDebug\n*F\n+ 1 AggregateRequest.kt\nme/ahoo/wow/webflux/route/command/AggregateRequestKt\n*L\n34#1:177,4\n37#1:181,4\n40#1:185,4\n47#1:189,4\n50#1:193,4\n61#1:197,4\n64#1:201,4\n85#1:205,4\n103#1:209,4\n123#1:213,4\n*E\n"})
public final class AggregateRequestKt {
    @Nullable
    public static final String getTenantId(@NotNull ServerRequest $this$getTenantId, @NotNull AggregateMetadata<?, ?> aggregateMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$getTenantId, (String)"<this>");
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        String $this$ifNotBlank$iv = aggregateMetadata.getStaticTenantId();
        boolean $i$f$ifNotBlank = false;
        CharSequence charSequence = $this$ifNotBlank$iv;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String it = $this$ifNotBlank$iv;
            boolean bl = false;
            return it;
        }
        $this$ifNotBlank$iv = (String)$this$getTenantId.pathVariables().get("tenantId");
        $i$f$ifNotBlank = false;
        charSequence = $this$ifNotBlank$iv;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String it = $this$ifNotBlank$iv;
            boolean bl = false;
            return it;
        }
        $this$ifNotBlank$iv = $this$getTenantId.headers().firstHeader("Command-Tenant-Id");
        $i$f$ifNotBlank = false;
        charSequence = $this$ifNotBlank$iv;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String it = $this$ifNotBlank$iv;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @Nullable
    public static final String getOwnerId(@NotNull ServerRequest $this$getOwnerId) {
        Intrinsics.checkNotNullParameter((Object)$this$getOwnerId, (String)"<this>");
        String $this$ifNotBlank$iv = (String)$this$getOwnerId.pathVariables().get("ownerId");
        boolean $i$f$ifNotBlank = false;
        CharSequence charSequence = $this$ifNotBlank$iv;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String it = $this$ifNotBlank$iv;
            boolean bl = false;
            return it;
        }
        $this$ifNotBlank$iv = $this$getOwnerId.headers().firstHeader("Command-Owner-Id");
        $i$f$ifNotBlank = false;
        charSequence = $this$ifNotBlank$iv;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String it = $this$ifNotBlank$iv;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @NotNull
    public static final String getTenantIdOrDefault(@NotNull ServerRequest $this$getTenantIdOrDefault, @NotNull AggregateMetadata<?, ?> aggregateMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$getTenantIdOrDefault, (String)"<this>");
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        String string = AggregateRequestKt.getTenantId($this$getTenantIdOrDefault, aggregateMetadata);
        if (string == null) {
            return "(0)";
        }
        return string;
    }

    @Nullable
    public static final String getAggregateId(@NotNull ServerRequest $this$getAggregateId) {
        Intrinsics.checkNotNullParameter((Object)$this$getAggregateId, (String)"<this>");
        String $this$ifNotBlank$iv = (String)$this$getAggregateId.pathVariables().get("id");
        boolean $i$f$ifNotBlank = false;
        CharSequence charSequence = $this$ifNotBlank$iv;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String it = $this$ifNotBlank$iv;
            boolean bl = false;
            return it;
        }
        $this$ifNotBlank$iv = $this$getAggregateId.headers().firstHeader("Command-Aggregate-Id");
        $i$f$ifNotBlank = false;
        charSequence = $this$ifNotBlank$iv;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String it = $this$ifNotBlank$iv;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @Nullable
    public static final String getAggregateId(@NotNull ServerRequest $this$getAggregateId, @NotNull AggregateRoute.Owner owner, @Nullable String ownerId) {
        Intrinsics.checkNotNullParameter((Object)$this$getAggregateId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (owner == AggregateRoute.Owner.AGGREGATE_ID) {
            String string = ownerId;
            if (string == null) {
                string = AggregateRequestKt.getAggregateId($this$getAggregateId);
            }
            return string;
        }
        return AggregateRequestKt.getAggregateId($this$getAggregateId);
    }

    @Nullable
    public static final String getAggregateId(@NotNull ServerRequest $this$getAggregateId, @NotNull AggregateRoute.Owner owner) {
        Intrinsics.checkNotNullParameter((Object)$this$getAggregateId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (owner == AggregateRoute.Owner.AGGREGATE_ID) {
            String string = AggregateRequestKt.getOwnerId($this$getAggregateId);
            if (string == null) {
                string = AggregateRequestKt.getAggregateId($this$getAggregateId);
            }
            return string;
        }
        return AggregateRequestKt.getAggregateId($this$getAggregateId);
    }

    @Nullable
    public static final Boolean getLocalFirst(@NotNull ServerRequest $this$getLocalFirst) {
        Intrinsics.checkNotNullParameter((Object)$this$getLocalFirst, (String)"<this>");
        String $this$ifNotBlank$iv = $this$getLocalFirst.headers().firstHeader("Command-Local-First");
        boolean $i$f$ifNotBlank = false;
        CharSequence charSequence = $this$ifNotBlank$iv;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String it = $this$ifNotBlank$iv;
            boolean bl = false;
            return Boolean.parseBoolean(it);
        }
        return null;
    }

    public static final boolean isSse(@NotNull ServerRequest $this$isSse) {
        Intrinsics.checkNotNullParameter((Object)$this$isSse, (String)"<this>");
        List list = $this$isSse.headers().accept();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"accept(...)");
        return Intrinsics.areEqual((Object)CollectionsKt.firstOrNull((List)list), (Object)MediaType.TEXT_EVENT_STREAM);
    }

    @NotNull
    public static final Duration getWaitTimeout(@NotNull ServerRequest $this$getWaitTimeout, @NotNull Duration duration) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$getWaitTimeout, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)duration, (String)"default");
                object = $this$getWaitTimeout.headers().firstHeader("Command-Wait-Timout");
                if (object == null || (object = StringsKt.toLongOrNull((String)object)) == null) break block2;
                long it = ((Number)object).longValue();
                boolean bl = false;
                Duration duration2 = Duration.ofMillis(it);
                object = duration2;
                if (duration2 != null) break block3;
            }
            object = duration;
        }
        return object;
    }

    public static /* synthetic */ Duration getWaitTimeout$default(ServerRequest serverRequest, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = CommandHandlerFunctionKt.getDEFAULT_TIME_OUT();
        }
        return AggregateRequestKt.getWaitTimeout(serverRequest, duration);
    }

    @NotNull
    public static final CommandStage getWaitStage(@NotNull ServerRequest $this$getWaitStage) {
        CommandStage commandStage;
        Intrinsics.checkNotNullParameter((Object)$this$getWaitStage, (String)"<this>");
        String $this$ifNotBlank$iv = $this$getWaitStage.headers().firstHeader("Command-Wait-Stage");
        boolean $i$f$ifNotBlank = false;
        CharSequence charSequence = $this$ifNotBlank$iv;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            commandStage = null;
        } else {
            String stage = $this$ifNotBlank$iv;
            boolean bl = false;
            String string = stage;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            commandStage = CommandStage.valueOf((String)string2);
        }
        CommandStage commandStage2 = commandStage;
        if (commandStage == null) {
            commandStage2 = CommandStage.PROCESSED;
        }
        return commandStage2;
    }

    @NotNull
    public static final String getWaitContext(@NotNull ServerRequest $this$getWaitContext) {
        Intrinsics.checkNotNullParameter((Object)$this$getWaitContext, (String)"<this>");
        String string = $this$getWaitContext.headers().firstHeader("Command-Wait-Context");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public static final String getWaitProcessor(@NotNull ServerRequest $this$getWaitProcessor) {
        Intrinsics.checkNotNullParameter((Object)$this$getWaitProcessor, (String)"<this>");
        String string = $this$getWaitProcessor.headers().firstHeader("Command-Wait-Processor");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public static final String getWaitFunction(@NotNull ServerRequest $this$getWaitFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$getWaitFunction, (String)"<this>");
        String string = $this$getWaitFunction.headers().firstHeader("Command-Wait-Function");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public static final CommandStage getWaitTailStage(@NotNull ServerRequest $this$getWaitTailStage) {
        CommandStage commandStage;
        Intrinsics.checkNotNullParameter((Object)$this$getWaitTailStage, (String)"<this>");
        String $this$ifNotBlank$iv = $this$getWaitTailStage.headers().firstHeader("Command-Wait-Tail-Stage");
        boolean $i$f$ifNotBlank = false;
        CharSequence charSequence = $this$ifNotBlank$iv;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            commandStage = null;
        } else {
            String stage = $this$ifNotBlank$iv;
            boolean bl = false;
            String string = stage;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            commandStage = CommandStage.valueOf((String)string2);
        }
        return commandStage;
    }

    @NotNull
    public static final String getWaitTailContext(@NotNull ServerRequest $this$getWaitTailContext) {
        Intrinsics.checkNotNullParameter((Object)$this$getWaitTailContext, (String)"<this>");
        String string = $this$getWaitTailContext.headers().firstHeader("Command-Wait-Tail-Context");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public static final String getWaitTailProcessor(@NotNull ServerRequest $this$getWaitTailProcessor) {
        Intrinsics.checkNotNullParameter((Object)$this$getWaitTailProcessor, (String)"<this>");
        String string = $this$getWaitTailProcessor.headers().firstHeader("Command-Wait-Tail-Processor");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public static final String getWaitTailFunction(@NotNull ServerRequest $this$getWaitTailFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$getWaitTailFunction, (String)"<this>");
        String string = $this$getWaitTailFunction.headers().firstHeader("Command-Wait-Tail-Function");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public static final WaitStrategy extractWaitStrategy(@NotNull ServerRequest $this$extractWaitStrategy, @NotNull CommandMessage<Object> commandMessage) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$extractWaitStrategy, (String)"<this>");
        Intrinsics.checkNotNullParameter(commandMessage, (String)"commandMessage");
        CommandStage stage = AggregateRequestKt.getWaitStage($this$extractWaitStrategy);
        CharSequence charSequence2 = AggregateRequestKt.getWaitContext($this$extractWaitStrategy);
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = commandMessage.getContextName();
        } else {
            charSequence = charSequence2;
        }
        String waitContext = (String)charSequence;
        NamedFunctionInfoData waitFunction = new NamedFunctionInfoData(waitContext, AggregateRequestKt.getWaitProcessor($this$extractWaitStrategy), AggregateRequestKt.getWaitFunction($this$extractWaitStrategy));
        CommandStage waitTailStage = AggregateRequestKt.getWaitTailStage($this$extractWaitStrategy);
        if (stage == CommandStage.SAGA_HANDLED && waitTailStage != null) {
            CharSequence charSequence3;
            CharSequence charSequence4 = AggregateRequestKt.getWaitTailContext($this$extractWaitStrategy);
            if (StringsKt.isBlank((CharSequence)charSequence4)) {
                boolean bl = false;
                charSequence3 = commandMessage.getContextName();
            } else {
                charSequence3 = charSequence4;
            }
            String string = AggregateRequestKt.getWaitTailFunction($this$extractWaitStrategy);
            String string2 = AggregateRequestKt.getWaitTailProcessor($this$extractWaitStrategy);
            String string3 = (String)charSequence3;
            NamedFunctionInfoData waitTailFunction = new NamedFunctionInfoData(string3, string2, string);
            return (WaitStrategy)SimpleWaitingForChain.Companion.chain(commandMessage.getCommandId(), waitFunction, waitTailStage, waitTailFunction);
        }
        return (WaitStrategy)WaitingForStage.Companion.stage(commandMessage.getCommandId(), stage, waitContext, waitFunction.getProcessorName(), waitFunction.getName());
    }
}

