/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.command;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandResult;
import me.ahoo.wow.command.wait.WaitStrategy;
import me.ahoo.wow.openapi.metadata.AggregateRouteMetadata;
import me.ahoo.wow.webflux.route.command.AggregateRequestKt;
import me.ahoo.wow.webflux.route.command.CommandHandlerFunctionKt;
import me.ahoo.wow.webflux.route.command.extractor.CommandMessageExtractor;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/ahoo/wow/webflux/route/command/CommandHandler;", "", "commandGateway", "Lme/ahoo/wow/command/CommandGateway;", "commandMessageExtractor", "Lme/ahoo/wow/webflux/route/command/extractor/CommandMessageExtractor;", "timeout", "Ljava/time/Duration;", "<init>", "(Lme/ahoo/wow/command/CommandGateway;Lme/ahoo/wow/webflux/route/command/extractor/CommandMessageExtractor;Ljava/time/Duration;)V", "handle", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/command/CommandResult;", "request", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "commandBody", "aggregateRouteMetadata", "Lme/ahoo/wow/openapi/metadata/AggregateRouteMetadata;", "sendCommand", "Lorg/reactivestreams/Publisher;", "commandMessage", "Lme/ahoo/wow/api/command/CommandMessage;", "wow-webflux"})
public final class CommandHandler {
    @NotNull
    private final CommandGateway commandGateway;
    @NotNull
    private final CommandMessageExtractor commandMessageExtractor;
    @NotNull
    private final Duration timeout;

    public CommandHandler(@NotNull CommandGateway commandGateway, @NotNull CommandMessageExtractor commandMessageExtractor, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)commandGateway, (String)"commandGateway");
        Intrinsics.checkNotNullParameter((Object)commandMessageExtractor, (String)"commandMessageExtractor");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.commandGateway = commandGateway;
        this.commandMessageExtractor = commandMessageExtractor;
        this.timeout = timeout;
    }

    public /* synthetic */ CommandHandler(CommandGateway commandGateway, CommandMessageExtractor commandMessageExtractor, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            duration = CommandHandlerFunctionKt.getDEFAULT_TIME_OUT();
        }
        this(commandGateway, commandMessageExtractor, duration);
    }

    @NotNull
    public final Flux<CommandResult> handle(@NotNull ServerRequest request, @NotNull Object commandBody, @NotNull AggregateRouteMetadata<?> aggregateRouteMetadata) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)commandBody, (String)"commandBody");
        Intrinsics.checkNotNullParameter(aggregateRouteMetadata, (String)"aggregateRouteMetadata");
        Flux flux = this.commandMessageExtractor.extract(aggregateRouteMetadata, commandBody, request).flatMapMany(arg_0 -> CommandHandler.handle$lambda$1(arg_0 -> CommandHandler.handle$lambda$0(this, request, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"flatMapMany(...)");
        return flux;
    }

    private final Publisher<CommandResult> sendCommand(CommandMessage<Object> commandMessage, ServerRequest request) {
        WaitStrategy waitStrategy = AggregateRequestKt.extractWaitStrategy(request, commandMessage);
        Duration commandWaitTimeout = AggregateRequestKt.getWaitTimeout(request, this.timeout);
        if (AggregateRequestKt.isSse(request)) {
            Flux flux = this.commandGateway.sendAndWaitStream(commandMessage, waitStrategy).timeout(commandWaitTimeout);
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"timeout(...)");
            return (Publisher)flux;
        }
        Mono mono = this.commandGateway.sendAndWait(commandMessage, waitStrategy).timeout(commandWaitTimeout);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"timeout(...)");
        return (Publisher)mono;
    }

    private static final Publisher handle$lambda$0(CommandHandler this$0, ServerRequest $request, CommandMessage it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.sendCommand((CommandMessage<Object>)it, $request);
    }

    private static final Publisher handle$lambda$1(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }
}

