/*
 * Decompiled with CFR 0.152.
 */
package me.araopj.cscreen.classes;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import me.araopj.cscreen.classes.Symbol;

public class CharSets {
    private static CharSets charSetsInstance = null;
    public char horizontal;
    public char vertical;
    public char[] corners;
    public char[] sideConnectors;
    private boolean isBox;
    private boolean isCalled;
    private final PrintStream out;

    private CharSets() {
        try {
            this.out = new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void normalSets() {
        this.horizontal = (char)45;
        this.vertical = (char)124;
        this.corners = new char[]{'+', '+', '+', '+'};
        this.sideConnectors = new char[]{'+', '+', '+', '+', '+'};
    }

    private void boxSets() {
        this.horizontal = (char)9480;
        this.vertical = (char)9474;
        this.corners = new char[]{'\u256d', '\u256e', '\u2570', '\u256f'};
        this.sideConnectors = new char[]{'\u251c', '\u2524', '\u252c', '\u2534', '\u253c'};
    }

    public void printChar(char c) {
        if (this.isBox) {
            this.out.print(c);
        } else {
            System.out.print(c);
        }
    }

    public static CharSets getInstance(Symbol symbol) {
        if (symbol == Symbol.NORMAL) {
            return CharSets.normalSetInstance();
        }
        if (symbol == Symbol.BOX_DRAWING) {
            return CharSets.boxSetInstance();
        }
        return CharSets.normalSetInstance();
    }

    private static CharSets normalSetInstance() {
        if (charSetsInstance == null) {
            charSetsInstance = new CharSets();
        }
        if (!CharSets.charSetsInstance.isCalled) {
            CharSets.charSetsInstance.isBox = false;
            charSetsInstance.normalSets();
        }
        return charSetsInstance;
    }

    private static CharSets boxSetInstance() {
        if (charSetsInstance == null) {
            charSetsInstance = new CharSets();
        }
        CharSets.charSetsInstance.isCalled = true;
        CharSets.charSetsInstance.isBox = true;
        charSetsInstance.boxSets();
        return charSetsInstance;
    }
}

