/*
 * Decompiled with CFR 0.152.
 */
package me.araopj.cscreen.components;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.araopj.cscreen.classes.CharSets;
import me.araopj.cscreen.classes.Position;
import me.araopj.cscreen.classes.Symbol;
import me.araopj.cscreen.classes.Utilities;

public class CList {
    protected char[][] screen;
    protected List<String> list;
    private String title = "";
    Position pos;
    protected int width;
    boolean displayed;
    CharSets charSets;

    public CList(String[] arr, int width) {
        this.setCharSets(null);
        List<String> temp = Arrays.asList(arr);
        this.list = new ArrayList<String>(temp);
        this.width = width;
    }

    public CList() {
        this.list = new ArrayList<String>();
        this.list.add("");
        this.setCharSets(null);
    }

    public CList(String[] arr) {
        List<String> temp = Arrays.asList(arr);
        this.list = new ArrayList<String>(temp);
        this.setCharSets(null);
    }

    protected void setCharSets(Symbol symbol) {
        this.charSets = CharSets.getInstance(symbol);
    }

    public void useBoxSet() {
        this.setCharSets(Symbol.BOX_DRAWING);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    private void generateScreen() {
        if (this.title.length() > 0 && this.width <= this.title.length()) {
            this.width = this.title.length();
        }
        int start = 0;
        if (!this.displayed) {
            this.width = this.width > Utilities.getMax(this.list.toArray(new String[0])) ? (this.width += 2) : Utilities.getMax(this.list.toArray(new String[0])) + 2;
            this.displayed = true;
        }
        int r = this.list.size() + 2;
        if (this.title.length() > 0) {
            r += 2;
            start = 2;
        }
        this.screen = new char[r][this.width];
        int idx = 0;
        String str = "";
        for (int i = 0; i < this.screen.length; ++i) {
            if (i > start && i < this.screen.length - 1) {
                str = this.list.get(idx);
                ++idx;
            }
            int k = 0;
            for (int j = 0; j < this.width; ++j) {
                this.screen[i][j] = 32;
                if (i == 0 || i == this.screen.length - 1) {
                    this.screen[i][j] = this.charSets.horizontal;
                    continue;
                }
                if (j == 0 || j == this.width - 1) {
                    this.screen[i][j] = this.charSets.vertical;
                }
                if (j <= 0 || k > str.length() - 1) continue;
                this.screen[i][j] = str.charAt(k++);
            }
        }
        CList.setCorners(this.screen[0], this.charSets.corners[0], this.charSets.corners[1], this.screen[this.screen.length - 1], this.charSets.corners[2], this.charSets.corners[3]);
    }

    protected static void setCorners(char[] chars, char corner, char corner2, char[] chars2, char corner3, char corner4) {
        chars[0] = corner;
        chars[chars.length - 1] = corner2;
        chars2[0] = corner3;
        chars2[chars.length - 1] = corner4;
    }

    public void setTitle(String title, Position pos) {
        this.title = title;
        this.pos = pos;
    }

    private void addTitle() {
        int start = 0;
        int end = 0;
        if (this.title.length() > 0) {
            int i;
            if (this.width - 4 < this.title.length()) {
                this.title = this.title.substring(0, this.screen[0].length - 2);
            }
            if (this.pos == Position.START) {
                start = 1;
                end = this.title.length() + 1;
            } else if (this.pos == Position.CENTER) {
                start = Math.abs((this.screen[0].length - this.title.length()) / 2) + 1;
                if (this.title.length() + 2 >= this.screen[0].length) {
                    start = 1;
                }
                end = start + this.title.length();
            } else if (this.pos == Position.END) {
                start = this.screen[0].length - this.title.length() - 1;
                end = start + this.title.length();
            }
            int j = 0;
            for (i = start; i < end; ++i) {
                this.screen[1][i] = this.title.charAt(j++);
            }
            for (i = 1; i < this.width - 1; ++i) {
                this.screen[2][i] = this.charSets.horizontal;
            }
            this.screen[2][0] = this.charSets.sideConnectors[0];
            this.screen[2][this.width - 1] = this.charSets.sideConnectors[1];
        }
    }

    public void display() throws UnsupportedEncodingException {
        this.generateScreen();
        if (this.title.length() > 0) {
            this.addTitle();
        }
        for (int i = 0; i < this.screen.length; ++i) {
            for (int j = 0; j < this.screen[0].length; ++j) {
                this.charSets.printChar(this.screen[i][j]);
            }
            System.out.println();
        }
    }

    public void addCounter() {
        int count = 1;
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.set(i, String.valueOf(count) + "." + this.list.get(i));
            ++count;
        }
    }

    public void addItem(String item) {
        if (this.list.get(0).equals("")) {
            this.list.remove(0);
        }
        this.list.add(item);
    }

    public String getItem(int index) {
        return this.list.get(index);
    }

    public void remove(int index) {
        this.list.remove(index);
        if (this.list.isEmpty()) {
            this.list.add("");
        }
    }

    public void set(int index, String item) {
        this.list.set(index, item);
    }
}

