/*
 * Decompiled with CFR 0.152.
 */
package me.araopj.cscreen.components;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.araopj.cscreen.classes.Position;
import me.araopj.cscreen.classes.Utilities;
import me.araopj.cscreen.components.CList;

public class CTable
extends CList {
    private final String[] columnHeader;
    private final HashMap<Integer, Position> alignments = new HashMap();
    int[] spaces;
    private final List<List<String>> list2D;
    private List<List<String>> tempList2D;
    private boolean onSearch;
    private boolean hasSeparator;

    public CTable(String ... columnHeader) {
        this.columnHeader = columnHeader;
        this.list2D = new ArrayList<List<String>>();
        if (columnHeader == null) {
            this.list2D.add(Arrays.asList(" ", " ", " ", " "));
        } else {
            this.list2D.add(Arrays.asList(Utilities.createEmptyList(columnHeader)));
        }
        this.list = new ArrayList();
    }

    public CTable(List<List<String>> arr, String ... columnHeader) {
        this.columnHeader = columnHeader;
        this.list2D = arr;
        this.list = new ArrayList();
    }

    public CTable(String[][] arr, String ... columnHeader) {
        this.columnHeader = columnHeader;
        this.list2D = Arrays.stream(arr).map(Arrays::asList).collect(Collectors.toList());
        this.list = new ArrayList();
    }

    public CTable(List<List<String>> arr, Position pos, boolean hasSeparator, String ... columnHeader) {
        this.columnHeader = columnHeader;
        this.list2D = arr;
        this.hasSeparator = hasSeparator;
        this.pos = pos;
        this.list = new ArrayList();
    }

    void init() {
        if (!this.onSearch) {
            this.tempList2D = new ArrayList<List<String>>(this.list2D);
        }
        int len = this.tempList2D.size() + 2;
        if (!this.onSearch) {
            if (this.columnHeader != null) {
                this.tempList2D = Utilities.addHeader(this.list2D, this.columnHeader);
                len = this.tempList2D.size() + 3;
            }
        } else {
            len = this.tempList2D.size() + 3;
        }
        this.onSearch = false;
        int colSize = this.combineRow(this.tempList2D) + 1;
        this.screen = new char[len][colSize];
    }

    @Override
    public void display() {
        try {
            this.generateScreen();
            PrintStream out = new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name());
            Arrays.stream(this.screen).forEach(value -> {
                IntStream.range(0, this.screen[0].length).forEachOrdered(j -> out.print(value[j]));
                out.println();
            });
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private int combineRow(List<List<String>> arr) {
        this.list = new ArrayList();
        char separator = this.charSets.vertical;
        if (!this.hasSeparator) {
            separator = ' ';
        }
        this.spaces = Utilities.getMaxByColumn(arr);
        int max = 0;
        if (this.columnHeader != null) {
            StringBuilder header = new StringBuilder();
            for (int i = 0; i < this.columnHeader.length; ++i) {
                int space = this.spaces[i];
                String firstLine = Utilities.alignedString(this.columnHeader[i], space, Position.CENTER);
                header.append(firstLine).append(separator);
            }
            this.list.add(header.toString());
        }
        for (List<String> strings : arr) {
            StringBuilder line = new StringBuilder();
            max = Math.max(max, Utilities.getMax(strings.toArray(new String[0])));
            for (int j = 0; j < strings.size(); ++j) {
                int space = this.spaces[j];
                String firstLine = Utilities.alignedString(strings.get(j), space, this.alignments.getOrDefault(j, null));
                line.append(firstLine).append(separator);
            }
            this.list.add(line.toString());
        }
        return ((String)this.list.get(0)).length();
    }

    public void hasSeparator(boolean hasSeparator) {
        this.hasSeparator = hasSeparator;
    }

    private void addColumnHeader(String str) {
        int j = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (i == 0 || i == str.length() - 1) {
                this.screen[1][i] = this.charSets.vertical;
                if (i == 0) {
                    this.screen[2][i] = this.charSets.sideConnectors[0];
                    continue;
                }
                this.screen[2][i] = this.charSets.sideConnectors[1];
                continue;
            }
            this.screen[1][i] = str.charAt(j++);
            if (this.screen[1][i] == this.charSets.vertical) {
                this.screen[2][i] = this.charSets.sideConnectors[4];
                this.screen[0][i] = this.charSets.sideConnectors[2];
                continue;
            }
            this.screen[2][i] = this.charSets.horizontal;
        }
    }

    private void generateScreen() {
        this.init();
        int start = 0;
        int end = this.screen.length - 1;
        int idx = 0;
        String str = "";
        for (int i = 0; i < this.screen.length; ++i) {
            if (i > start && i < end) {
                str = (String)this.list.get(idx);
                ++idx;
            }
            int k = 0;
            for (int j = 0; j < this.screen[0].length; ++j) {
                this.screen[i][j] = 32;
                if (i == 0 || i == this.screen.length - 1) {
                    this.screen[i][j] = this.charSets.horizontal;
                    if (i == this.screen.length - 1 && this.screen[this.screen.length - 2][j] == this.charSets.vertical) {
                        this.screen[i][j] = this.charSets.sideConnectors[3];
                    }
                } else {
                    if (j > 0) {
                        if (k > str.length() - 1) continue;
                        this.screen[i][j] = str.charAt(k++);
                    }
                    if (j == 0 || j == this.screen[0].length - 1) {
                        this.screen[i][j] = this.charSets.vertical;
                    }
                }
                if (i != 1 || this.screen[i][j] != this.charSets.vertical) continue;
                this.screen[0][j] = this.charSets.sideConnectors[2];
            }
        }
        CTable.setCorners(this.screen[0], this.charSets.corners[0], this.charSets.corners[1], this.screen[this.screen.length - 1], this.charSets.corners[2], this.charSets.corners[3]);
        if (this.columnHeader != null) {
            this.addColumnHeader((String)this.list.get(0) + " ");
        }
    }

    public void addRow(String ... row) {
        if (this.list2D.get(0).get(0).equals(" ")) {
            this.list2D.remove(0);
        }
        this.list2D.add(Arrays.asList(row));
    }

    public List<String> getRow(int index) {
        return this.list2D.get(index);
    }

    public List<String> getColumn(int index) {
        return this.list2D.stream().map(value -> (String)value.get(index)).collect(Collectors.toList());
    }

    public void removeRow(int index) {
        this.list2D.remove(index);
        if (this.list2D.isEmpty()) {
            if (this.columnHeader == null) {
                this.list2D.add(Arrays.asList(" ", " ", " ", " "));
            } else {
                this.list2D.add(Arrays.asList(Utilities.createEmptyList(this.columnHeader)));
            }
        }
    }

    public String getCell(int row, int column) {
        return this.list2D.get(row).get(column);
    }

    public void setCell(int row, int column, String str) {
        this.list2D.get(row).set(column, str);
    }

    public void addList(List<List<String>> arr) {
        if (this.list2D.get(0).get(0).equals(" ")) {
            this.list2D.remove(0);
        }
        this.list2D.addAll(arr);
    }

    public List<List<String>> findRows(int column, String text) {
        return this.list2D.stream().filter(row -> ((String)row.get(column)).equals(text)).collect(Collectors.toList());
    }

    public void setColumnAlignment(int columnIndex, Position position) {
        this.alignments.put(columnIndex, position);
    }

    public int getTotal(int columnIndex) {
        return this.list2D.stream().filter(i -> i.stream().filter(Utilities::isNumeric).isParallel()).mapToInt(row -> columnIndex).sum();
    }

    public double getFloatTotal(int columnIndex) {
        return this.list2D.stream().filter(i -> i.stream().filter(Utilities::isNumeric).isParallel()).mapToDouble(row -> columnIndex).sum();
    }
}

