/*
 * Decompiled with CFR 0.152.
 */
package me.araopj.cscreen.components;

import me.araopj.cscreen.classes.CharSets;
import me.araopj.cscreen.classes.Position;
import me.araopj.cscreen.classes.Symbol;

public class Screen {
    char[][] screen;
    private int c;
    private int r;
    private boolean hasBorder;
    private String title = "";
    CharSets charSets;

    public Screen() {
        this.setCharSets(null);
        if (this.r < 4) {
            this.r = 3;
        }
        if (this.c < 5) {
            this.c = 4;
        }
        this.screen = new char[this.r][this.c];
    }

    public Screen(int r, int c) {
        this.setCharSets(null);
        this.r = r;
        this.c = c;
        if (r < 4) {
            this.r = 3;
        }
        if (c < 5) {
            this.c = 4;
        }
        this.screen = new char[r][c];
        this.generateScreen();
    }

    public Screen(int r, int c, boolean hasBorder) {
        this.setCharSets(null);
        this.hasBorder = hasBorder;
        this.r = r;
        this.c = c;
        if (r < 4) {
            this.r = 3;
        }
        if (c < 5) {
            this.c = 4;
        }
        this.screen = new char[r][c];
        this.generateScreen();
    }

    protected void setCharSets(Symbol symbol) {
        this.charSets = CharSets.getInstance(symbol);
    }

    public void useBoxSet() {
        this.setCharSets(Symbol.BOX_DRAWING);
        this.generateScreen();
    }

    public void setDimension(int r, int c) {
        this.r = r;
        this.c = c;
    }

    public void setTitle(String title) {
        this.clearTitle();
        this.addTitle(title, Position.START);
    }

    public void setTitlePosition(Position pos) {
        this.clearTitle();
        this.addTitle(this.title, pos);
    }

    public void addTitle(String title, Position pos) {
        this.clearTitle();
        this.title = title;
        int start = 0;
        int end = 0;
        if (this.screen[0].length - 4 < this.title.length()) {
            this.title = this.title.substring(0, this.screen[0].length - 2);
        }
        if (pos == Position.START) {
            start = 1;
            end = this.title.length() + 1;
        } else if (pos == Position.CENTER) {
            start = Math.abs((this.screen[0].length - this.title.length()) / 2 - 2);
            end = start + this.title.length();
        } else if (pos == Position.END) {
            start = this.screen[0].length - this.title.length() - 1;
            end = start + this.title.length();
        }
        int j = 0;
        for (int i = start; i < end; ++i) {
            this.screen[1][i] = this.title.charAt(j++);
        }
    }

    private void clearTitle() {
        for (int i = 1; i < this.screen[0].length - 1; ++i) {
            this.screen[1][i] = 32;
        }
    }

    public void generateScreen() {
        for (int i = 0; i < this.screen.length; ++i) {
            for (int j = 0; j < this.screen[i].length; ++j) {
                this.screen[i][j] = 32;
                if (i == 0 || i == this.screen.length - 1) {
                    this.screen[i][j] = this.charSets.horizontal;
                } else if (j == 0 || j == this.screen[i].length - 1) {
                    this.screen[i][j] = this.charSets.vertical;
                }
                if (!this.hasBorder) continue;
                if (i == 2 || i == this.screen.length - 2) {
                    if (j <= 0 || j >= this.screen[i].length - 1) continue;
                    this.screen[i][j] = this.charSets.horizontal;
                    continue;
                }
                if (i <= 1 || i >= this.screen.length - 1 || j != 1 && j != this.screen[i].length - 2) continue;
                this.screen[i][j] = this.charSets.vertical;
            }
        }
        this.screen[0][0] = this.charSets.corners[0];
        this.screen[0][this.screen[0].length - 1] = this.charSets.corners[1];
        this.screen[this.screen.length - 1][0] = this.charSets.corners[2];
        this.screen[this.screen.length - 1][this.screen[0].length - 1] = this.charSets.corners[3];
        if (this.hasBorder) {
            this.screen[2][1] = this.charSets.corners[0];
            this.screen[2][this.screen[0].length - 2] = this.charSets.corners[1];
            this.screen[this.screen.length - 2][1] = this.charSets.corners[2];
            this.screen[this.screen.length - 2][this.screen[0].length - 2] = this.charSets.corners[3];
        }
    }

    public void display() {
        char[][] cArray = this.screen;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char[] chars;
            for (char aChar : chars = cArray[i]) {
                this.charSets.printChar(aChar);
            }
            System.out.println();
        }
    }
}

