/*
 * Decompiled with CFR 0.152.
 */
package me.araopj.cscreen.components;

import me.araopj.cscreen.components.Box;
import me.araopj.cscreen.components.Screen;

public class TextBox
extends Box {
    String text = "";
    Screen sc;
    char[][] screen;
    private int height = 3;

    public TextBox(int r, int c) {
        super(r, c);
    }

    public void setText(String text) {
        this.text = text;
        if (this.sc != null) {
            this.clear();
            this.place(this.sc);
        }
    }

    @Override
    public void setHeight(int height) {
        if (height < 4) {
            height = 3;
        }
        this.height = height;
    }

    public void clear() {
        int end;
        int start = this.c;
        if (this.width == 0) {
            end = this.c + this.text.length() + 2;
        } else {
            if (this.width < this.text.length()) {
                this.text = this.text.substring(0, this.width);
            }
            end = this.c + this.width + 2;
        }
        if (this.screen != null) {
            for (int i = start + 1; i < end - 1; ++i) {
                this.screen[this.r + 1][i] = 32;
            }
        }
    }

    @Override
    public void place(Screen sc) {
        int end;
        this.sc = sc;
        this.screen = sc.screen;
        this.charSets = sc.charSets;
        int start = this.c;
        if (this.width == 0) {
            end = this.c + this.text.length() + 2;
        } else {
            if (this.width < this.text.length()) {
                this.text = this.text.substring(0, this.width);
            }
            end = this.c + this.width + 2;
        }
        for (int i = this.r; i < this.r + this.height; ++i) {
            int k = 0;
            for (int j = start; j < end; ++j) {
                if (i == this.r || i == this.r + (this.height - 1)) {
                    this.screen[i][j] = this.charSets.horizontal;
                } else if (j == start || j == end - 1) {
                    this.screen[i][j] = this.charSets.vertical;
                }
                if (i != this.r + 1 || j <= start || j >= end - 1 || this.text.isEmpty() || k >= this.text.length()) continue;
                this.screen[i][j] = this.text.charAt(k++);
            }
        }
        this.screen[this.r][start] = this.charSets.corners[0];
        this.screen[this.r][end - 1] = this.charSets.corners[1];
        this.screen[this.r + (this.height - 1)][start] = this.charSets.corners[2];
        this.screen[this.r + (this.height - 1)][end - 1] = this.charSets.corners[3];
    }
}

