/*
 * Decompiled with CFR 0.152.
 */
package me.arminb.spidersilk.rt;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import me.arminb.spidersilk.rt.StackMatcher;

public class SpiderSilk {
    private static SpiderSilk instance;
    private final String hostname;
    private final String port;
    private final StackMatcher stackMatcher;
    private ThreadLocal<Boolean> allowBlocking;

    public static SpiderSilk getInstance() {
        return instance;
    }

    private SpiderSilk(String hostname, String port) {
        this.hostname = hostname;
        this.port = port;
        this.stackMatcher = new StackMatcher();
        this.allowBlocking = new ThreadLocal();
        this.allowBlocking.set(true);
    }

    public static void configure(String hostname, String port) {
        if (instance == null) {
            instance = new SpiderSilk(hostname, port);
        }
    }

    public void allowBlocking() {
        this.allowBlocking.set(true);
    }

    public void enforceOrder(String eventName, String stack) {
        if (!this.isEventAlreadySent(eventName) && (stack == null || this.stackMatcher.match(stack)) && this.allowBlocking.get().booleanValue() && this.isBlockingConditionSatisfied(eventName)) {
            this.blockAndPoll(eventName);
            this.sendEvent(eventName);
            this.allowBlocking.set(false);
        }
    }

    public void garbageCollection(final String eventName) {
        Thread gcThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!SpiderSilk.this.isEventAlreadySent(eventName) && SpiderSilk.this.isBlockingConditionSatisfied(eventName)) {
                    SpiderSilk.this.blockAndPoll(eventName);
                    System.gc();
                    SpiderSilk.this.sendEvent(eventName);
                }
            }
        });
        gcThread.start();
    }

    private boolean isEventAlreadySent(String eventName) {
        try {
            URL url = new URL("http://" + this.hostname + ":" + this.port + "/events/" + eventName);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            return connection.getResponseCode() == 200;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isBlockingConditionSatisfied(String eventName) {
        try {
            URL url = new URL("http://" + this.hostname + ":" + this.port + "/blockDependencies/" + eventName);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            return connection.getResponseCode() == 200;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void blockAndPoll(String eventName) {
        this.blockAndPoll(eventName, false);
    }

    public void blockAndPoll(String eventName, Boolean includeEvent) {
        block4: while (true) {
            try {
                while (true) {
                    Integer eventInclusion = includeEvent != false ? 1 : 0;
                    URL url = new URL("http://" + this.hostname + ":" + this.port + "/dependencies/" + eventName + "?includeEvent=" + eventInclusion);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.connect();
                    if (connection.getResponseCode() == 200) break block4;
                    Thread.sleep(5L);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void sendEvent(String eventName) {
        try {
            URL url = new URL("http://" + this.hostname + ":" + this.port + "/events");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            String input = "{\"name\":\"" + eventName + "\"}";
            OutputStream os = connection.getOutputStream();
            os.write(input.getBytes());
            connection.getResponseCode();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

