/*
 * Decompiled with CFR 0.152.
 */
package me.atam.atam4j;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import me.atam.atam4j.AcceptanceTestsRunnerTaskScheduler;
import me.atam.atam4j.Monitor;
import me.atam.atam4j.NoTestClassFoundException;
import me.atam.atam4j.health.AcceptanceTestsHealthCheck;
import me.atam.atam4j.health.AcceptanceTestsState;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class Atam4j {
    private final HealthCheckRegistry healthCheckRegistry;
    private final AcceptanceTestsState acceptanceTestsState = new AcceptanceTestsState();
    private final AcceptanceTestsRunnerTaskScheduler acceptanceTestsRunnerTaskScheduler;

    public Atam4j(AcceptanceTestsRunnerTaskScheduler acceptanceTestsRunnerTaskScheduler, HealthCheckRegistry healthCheckRegistry) {
        this.acceptanceTestsRunnerTaskScheduler = acceptanceTestsRunnerTaskScheduler;
        this.healthCheckRegistry = healthCheckRegistry;
    }

    public void initialise() {
        this.acceptanceTestsRunnerTaskScheduler.scheduleAcceptanceTestsRunnerTask(this.acceptanceTestsState);
        AcceptanceTestsHealthCheck healthCheck = new AcceptanceTestsHealthCheck(this.acceptanceTestsState);
        this.healthCheckRegistry.register("Acceptance Tests HealthCheck", (HealthCheck)healthCheck);
    }

    public static class Atam4jBuilder {
        private HealthCheckRegistry healthCheckRegistry;
        private Optional<Class[]> testClasses = Optional.empty();
        private long initialDelay = 60L;
        private long period = 300L;
        private TimeUnit unit = TimeUnit.SECONDS;

        public Atam4jBuilder(HealthCheckRegistry healthCheckRegistry) {
            this.healthCheckRegistry = (HealthCheckRegistry)Preconditions.checkNotNull((Object)healthCheckRegistry);
        }

        public Atam4jBuilder withTestClasses(Class ... testClasses) {
            this.testClasses = Optional.of(testClasses);
            return this;
        }

        public Atam4jBuilder withInitialDelay(long initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        public Atam4jBuilder withPeriod(long period) {
            this.period = period;
            return this;
        }

        public Atam4jBuilder withUnit(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        public Atam4j build() {
            return new Atam4j(new AcceptanceTestsRunnerTaskScheduler(this.findTestClasses(), this.initialDelay, this.period, this.unit), this.healthCheckRegistry);
        }

        private Class[] findTestClasses() {
            Class[] classes = this.testClasses.orElseGet(() -> (Class[])new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()})).getTypesAnnotatedWith(Monitor.class).stream().toArray(Class[]::new));
            if (classes.length == 0) {
                throw new NoTestClassFoundException("Could not find any annotated test classes and no classes were provided via the Atam4jBuilder.");
            }
            return classes;
        }
    }
}

