/*
 * Decompiled with CFR 0.152.
 */
package me.atam.atam4j.health;

import com.codahale.metrics.health.HealthCheck;
import me.atam.atam4j.health.AcceptanceTestsState;
import org.junit.runner.notification.Failure;

public class AcceptanceTestsHealthCheck
extends HealthCheck {
    public static final String TOO_EARLY_MESSAGE = "Too early to tell - tests not complete yet";
    public static final String OK_MESSAGE = "All is A OK!";
    public static final String FAILURE_MESSAGE = "Number of failures:";
    private static AcceptanceTestsState testsState;
    public static final String NAME = "Acceptance Tests HealthCheck";

    public AcceptanceTestsHealthCheck(AcceptanceTestsState acceptanceTestsState) {
        testsState = acceptanceTestsState;
    }

    protected HealthCheck.Result check() throws Exception {
        if (testsState.getResult().isPresent()) {
            if (testsState.getResult().get().wasSuccessful()) {
                return HealthCheck.Result.healthy((String)OK_MESSAGE);
            }
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append(String.format("Number of failures: %d.", testsState.getResult().get().getFailureCount()));
            for (Failure failure : testsState.getResult().get().getFailures()) {
                messageBuilder.append(" ");
                messageBuilder.append(failure.getMessage());
            }
            return HealthCheck.Result.unhealthy((String)messageBuilder.toString());
        }
        return HealthCheck.Result.healthy((String)TOO_EARLY_MESSAGE);
    }
}

