/*
 * Decompiled with CFR 0.152.
 */
package me.atam.atam4j.resources;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import me.atam.atam4j.TestRunListener;
import me.atam.atam4jdomain.TestsRunResult;

@Path(value="/tests")
public class TestStatusResource {
    private TestRunListener testRunListener;

    public TestStatusResource(TestRunListener testRunListener) {
        this.testRunListener = testRunListener;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getTestStatus() {
        TestsRunResult testRunResult = this.testRunListener.getTestsRunResult();
        if (testRunResult.getStatus().equals((Object)TestsRunResult.Status.FAILURES)) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)testRunResult).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)testRunResult).build();
    }

    @GET
    @Path(value="{category}")
    @Produces(value={"application/json"})
    public Response getTestStatusForACategory(@PathParam(value="category") String category) {
        this.testRunListener.getTestsRunResult().getTests().removeIf(testResult -> !testResult.getCategory().equalsIgnoreCase(category));
        TestsRunResult categorisedTestsResult = new TestsRunResult(this.testRunListener.getTestsRunResult().getTests());
        if (categorisedTestsResult.getTests().size() <= 0) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (categorisedTestsResult.getStatus().equals((Object)TestsRunResult.Status.FAILURES)) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)categorisedTestsResult).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)categorisedTestsResult).build();
    }
}

