/*
 * Decompiled with CFR 0.152.
 */
package me.atam.atam4j;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.atam.atam4j.MonitorCategory;
import me.atam.atam4jdomain.IndividualTestResult;
import me.atam.atam4jdomain.TestsRunResult;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRunListener
extends RunListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestRunListener.class);
    private volatile Map<TestIdentifier, IndividualTestResult> inProgressTestResults;
    private volatile Map<TestIdentifier, IndividualTestResult> completedTestResults;
    private volatile boolean testsFinished = false;

    public void testRunStarted(Description description) throws Exception {
        this.inProgressTestResults = new HashMap<TestIdentifier, IndividualTestResult>();
    }

    public void testStarted(Description description) throws Exception {
        this.inProgressTestResults.put(new TestIdentifier(description), new IndividualTestResult(description.getClassName(), description.getMethodName(), this.getCategoryName(description), true));
    }

    public void testFailure(Failure failure) throws Exception {
        IndividualTestResult individualTestResult = this.inProgressTestResults.get(new TestIdentifier(failure.getDescription()));
        individualTestResult.setPassed(false);
    }

    public TestsRunResult getTestsRunResult() {
        if (this.testsFinished) {
            return new TestsRunResult(this.completedTestResults.values());
        }
        return new TestsRunResult(Collections.emptyList(), TestsRunResult.Status.TOO_EARLY);
    }

    public TestsRunResult getTestsRunResult(String category) {
        if (this.testsFinished) {
            return new TestsRunResult((Collection)this.completedTestResults.values().stream().filter(testResult -> testResult.getCategory().equalsIgnoreCase(category)).collect(Collectors.toList()));
        }
        return new TestsRunResult(Collections.emptyList(), TestsRunResult.Status.TOO_EARLY);
    }

    public void testRunFinished(Result result) throws Exception {
        this.testsFinished = true;
        this.completedTestResults = this.inProgressTestResults;
    }

    private String getCategoryName(Description description) {
        String category = "default";
        MonitorCategory monitorCategoryAnnotation = (MonitorCategory)description.getAnnotation(MonitorCategory.class);
        if (monitorCategoryAnnotation != null) {
            category = monitorCategoryAnnotation.name();
        }
        return category;
    }

    private static class TestIdentifier {
        private Class testClass;
        private String testName;

        public TestIdentifier(Description description) {
            this.testClass = description.getTestClass();
            this.testName = description.getMethodName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestIdentifier that = (TestIdentifier)o;
            return Objects.equals(this.testClass, that.testClass) && Objects.equals(this.testName, that.testName);
        }

        public int hashCode() {
            return Objects.hash(this.testClass, this.testName);
        }
    }
}

