/*
 * Decompiled with CFR 0.152.
 */
package me.atam.atam4j.logging;

import java.util.Date;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingListener
extends RunListener {
    private static Logger LOGGER = LoggerFactory.getLogger(LoggingListener.class);

    public void testRunStarted(Description description) throws Exception {
        LOGGER.info("Starting tests at {}", (Object)new Date());
    }

    public void testRunFinished(Result result) throws Exception {
        LOGGER.info("Tests finishes at {}", (Object)new Date());
        LOGGER.info("Report :: total run = {}, failures = {}, in time = {} milliseconds", new Object[]{result.getRunCount(), result.getFailureCount(), result.getRunTime()});
    }

    public void testStarted(Description description) throws Exception {
        LOGGER.debug("Starting {}", (Object)description.getDisplayName());
    }

    public void testFinished(Description description) throws Exception {
        LOGGER.debug("Finished {}", (Object)description.getDisplayName());
    }

    public void testFailure(Failure failure) throws Exception {
        LOGGER.error(String.format("Test %s failed: %s", failure.getTestHeader(), failure.getDescription()), failure.getException());
    }

    public void testAssumptionFailure(Failure failure) {
        LOGGER.error(String.format("Test %s assumption failed: %s", failure.getTestHeader(), failure.getDescription()), failure.getException());
    }

    public void testIgnored(Description description) throws Exception {
        LOGGER.debug("Test {} ignored: ", (Object)description.getDisplayName());
    }
}

