/*
 * Decompiled with CFR 0.152.
 */
package me.atam.atam4j.resources;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import me.atam.atam4j.TestRunListener;
import me.atam.atam4jdomain.TestsRunResult;

@Path(value="/tests")
@Produces(value={"application/json"})
public class TestStatusResource {
    private final TestRunListener testRunListener;

    public TestStatusResource(TestRunListener testRunListener) {
        this.testRunListener = testRunListener;
    }

    @GET
    public Response getTestStatus() {
        return this.buildResponse(this.testRunListener.getTestsRunResult());
    }

    @GET
    @Path(value="{category}")
    public Response getTestStatusForACategory(@PathParam(value="category") String category) {
        return this.buildResponse(this.testRunListener.getTestsRunResult(category));
    }

    private Response buildResponse(TestsRunResult testRunResult) {
        if (testRunResult.getStatus().equals((Object)TestsRunResult.Status.FAILURES)) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)testRunResult).build();
        }
        if (testRunResult.getStatus().equals((Object)TestsRunResult.Status.CATEGORY_NOT_FOUND)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)testRunResult).build();
    }
}

