/*
 * Decompiled with CFR 0.152.
 */
package me.busr.jesse;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.busr.jesse.DefaultSessionManager;
import me.busr.jesse.SseEventBuilder;
import me.busr.jesse.SseSessionBuilder;
import me.busr.jesse.SseSessionKeepAlive;
import me.busr.jesse.SseSessionManager;
import me.busr.jesse.feature.MapperFeature;

public class JesseServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(JesseServlet.class.getName());
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private SseSessionManager manager = new DefaultSessionManager();
    private String domain = "*";
    private boolean keepAlive = false;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync();
        HttpServletResponse asyncContextResponse = (HttpServletResponse)asyncContext.getResponse();
        if (this.domain == null || this.domain.contains("*")) {
            asyncContextResponse.addHeader("Access-Control-Allow-Origin", request.getServerName());
        } else {
            asyncContextResponse.addHeader("Access-Control-Allow-Origin", this.domain);
        }
        asyncContextResponse.addHeader("Access-Control-Expose-Headers", "*");
        asyncContextResponse.addHeader("Access-Control-Allow-Credentials", "true");
        EXECUTOR.submit(() -> SseSessionBuilder.buildSession(asyncContext, this.manager, this.keepAlive));
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync();
        HttpServletResponse asyncContextResponse = (HttpServletResponse)asyncContext.getResponse();
        if (this.domain == null || this.domain.contains("*")) {
            asyncContextResponse.addHeader("Access-Control-Allow-Origin", request.getServerName());
        } else {
            asyncContextResponse.addHeader("Access-Control-Allow-Origin", this.domain);
        }
        asyncContextResponse.addHeader("Access-Control-Expose-Headers", "*");
        asyncContextResponse.addHeader("Access-Control-Allow-Credentials", "true");
        asyncContextResponse.flushBuffer();
        asyncContext.complete();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String sessionManagerClassNameParameter = this.getServletConfig().getInitParameter("me.busr.jesse.session.manager");
        String domainInitParameter = this.getServletConfig().getInitParameter("me.busr.jesse.session.domains");
        String keepAliveParameter = this.getServletConfig().getInitParameter("me.busr.jesse.session.keepalive.enabled");
        String keepAliveTimerParameter = this.getServletConfig().getInitParameter("me.busr.jesse.session.keepalive.interval");
        String mapperFeaturesParameter = this.getServletConfig().getInitParameter("me.busr.jesse.feature");
        if (domainInitParameter != null) {
            this.domain = domainInitParameter;
        }
        if (keepAliveParameter != null && keepAliveParameter.equals("true")) {
            if (keepAliveTimerParameter != null) {
                try {
                    long interval = Long.parseLong(keepAliveTimerParameter.trim());
                    SseSessionKeepAlive.setInterval(interval);
                    LOG.info("Set the Keep-Alive interval to ".concat(String.valueOf(interval)).concat(" seconds"));
                }
                catch (Exception ex) {
                    LOG.severe(ex.getMessage());
                    LOG.info("Defaulting to Keep-Alive interval of 120 seconds");
                }
            }
            SseSessionKeepAlive.start();
            this.keepAlive = true;
        }
        try {
            SseSessionManager sessionManager;
            Class<?> sessionManagerClass = Class.forName(sessionManagerClassNameParameter);
            this.manager = sessionManager = (SseSessionManager)sessionManagerClass.newInstance();
            LOG.info("using ".concat(sessionManagerClass.getCanonicalName()).concat(" as session manager"));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException ex) {
            LOG.warning(ex.getMessage().concat(" defaulting to built in session manager"));
        }
        if (mapperFeaturesParameter != null) {
            if (mapperFeaturesParameter.contains(",")) {
                String[] features;
                for (String feature : features = mapperFeaturesParameter.split(",")) {
                    this.addFeature(feature);
                }
            } else {
                this.addFeature(mapperFeaturesParameter);
            }
        }
    }

    public void addFeature(String featureClassName) {
        try {
            Class<?> mapperFeatureClass = Class.forName(featureClassName);
            MapperFeature mapperFeature = (MapperFeature)mapperFeatureClass.newInstance();
            SseEventBuilder.addMapper(mapperFeature);
            LOG.info("using ".concat(mapperFeatureClass.getCanonicalName()));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException ex) {
            LOG.warning(ex.getMessage());
        }
    }
}

