/*
 * Decompiled with CFR 0.152.
 */
package me.busr.jesse;

import java.util.HashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import me.busr.jesse.SseEvent;
import me.busr.jesse.feature.MapperFeature;
import me.busr.jesse.feature.PlainTextMapperFeature;

public class SseEventBuilder {
    private Object data;
    private String event;
    private String id;
    private String retry;
    private MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
    private static final HashMap<MediaType, MapperFeature> MAPPER_MAP = new HashMap();

    protected SseEventBuilder() {
    }

    public SseEventBuilder data(Object data) {
        this.data = data;
        return this;
    }

    public SseEventBuilder event(String event) {
        this.event = String.valueOf(event);
        return this;
    }

    public SseEventBuilder id(Object id) {
        this.id = String.valueOf(id);
        return this;
    }

    public SseEventBuilder retry(long retry) {
        this.retry = String.valueOf(retry);
        return this;
    }

    public SseEventBuilder mediaType(String mediaType) {
        this.mediaType = MediaType.valueOf((String)mediaType);
        return this;
    }

    public SseEvent build() throws WebApplicationException {
        StringBuilder builder = new StringBuilder();
        if (this.id != null) {
            builder.append("id: ").append(this.id).append("\n");
        }
        if (this.event != null) {
            builder.append("event: ").append(this.event).append("\n");
        }
        if (this.retry != null) {
            builder.append("retry: ").append(this.retry).append("\n");
        }
        if (this.data != null) {
            try {
                builder.append("data: ").append(MAPPER_MAP.getOrDefault(this.mediaType, new PlainTextMapperFeature()).serialize(this.data));
            }
            catch (NullPointerException ex) {
                throw new WebApplicationException(builder.append("Error : No serializer for media type ").append(this.mediaType.getType()).append(" was found").toString(), 400);
            }
        }
        builder.append("\n\n");
        return new SseEvent(builder.toString());
    }

    protected static final void addMapper(MapperFeature mapper) {
        MAPPER_MAP.put(mapper.getMediaType(), mapper);
    }

    static {
        MAPPER_MAP.put(MediaType.TEXT_PLAIN_TYPE, new PlainTextMapperFeature());
    }
}

