/*
 * Decompiled with CFR 0.152.
 */
package me.busr.jesse;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import me.busr.jesse.SseEvent;
import me.busr.jesse.SseSessionKeepAlive;
import me.busr.jesse.SseSessionManager;

public class SseSession {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private final AsyncContext asyncContext;
    private final ReentrantLock lock;
    private static final Logger LOG = Logger.getLogger(SseSession.class.getName());
    private final SseSessionManager sessionManager;
    private final boolean keepAlive;

    protected SseSession(SseSessionManager sessionManager, AsyncContext asyncContext) {
        this.sessionManager = sessionManager;
        this.lock = new ReentrantLock();
        this.asyncContext = asyncContext;
        asyncContext.setTimeout(-1L);
        asyncContext.getResponse().setContentType("text/event-stream");
        asyncContext.getResponse().setCharacterEncoding("UTF-8");
        this.keepAlive = false;
        this.openSession();
    }

    protected SseSession(SseSessionManager sessionManager, AsyncContext asyncContext, boolean keepAlive) {
        this.sessionManager = sessionManager;
        this.lock = new ReentrantLock();
        this.asyncContext = asyncContext;
        asyncContext.setTimeout(-1L);
        asyncContext.getResponse().setContentType("text/event-stream");
        asyncContext.getResponse().setCharacterEncoding("UTF-8");
        this.keepAlive = keepAlive;
        this.openSession();
    }

    private void removeKeepAlive() {
        if (this.keepAlive) {
            SseSessionKeepAlive.removeSession(this);
        }
    }

    private void addKeepAlive() {
        if (this.keepAlive) {
            SseSessionKeepAlive.addSession(this);
        }
    }

    public void pushEvent(final SseEvent event) {
        EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                SseSession.this.lock.lock();
                try {
                    if (event != null) {
                        ServletOutputStream outputStream = SseSession.this.asyncContext.getResponse().getOutputStream();
                        outputStream.print(event.getString());
                        outputStream.flush();
                    }
                }
                catch (IOException ex) {
                    SseSession.this.closeSession();
                }
                catch (IllegalStateException | NullPointerException ex) {
                    SseSession.this.sessionError(ex);
                }
                catch (Throwable ex) {
                    LOG.severe(ex.getMessage());
                }
                finally {
                    SseSession.this.lock.unlock();
                }
            }
        });
    }

    private void sessionError(Throwable ex) {
        LOG.severe(ex.getMessage());
        this.removeKeepAlive();
        this.asyncContext.complete();
        this.sessionManager.onError(this);
    }

    public void closeSession() {
        try {
            this.sessionManager.onClose(this);
        }
        catch (WebApplicationException ex) {
            try {
                HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
                response.sendError(ex.getResponse().getStatus());
                response.flushBuffer();
            }
            catch (IOException | ClassCastException | IllegalStateException | NullPointerException exception) {
                // empty catch block
            }
        }
        finally {
            this.removeKeepAlive();
            this.asyncContext.complete();
        }
    }

    private void openSession() {
        try {
            this.sessionManager.onOpen(this);
            this.addKeepAlive();
        }
        catch (WebApplicationException ex) {
            try {
                HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
                response.sendError(ex.getResponse().getStatus());
                response.flushBuffer();
            }
            catch (IOException | ClassCastException | IllegalStateException | NullPointerException exception) {
            }
            finally {
                this.removeKeepAlive();
                this.asyncContext.complete();
            }
        }
    }

    public Cookie[] getCookies() throws WebApplicationException {
        try {
            HttpServletRequest r = (HttpServletRequest)this.asyncContext.getRequest();
            return r.getCookies();
        }
        catch (ClassCastException | IllegalStateException | NullPointerException ex) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public Cookie getCookie(String cookieName) throws WebApplicationException {
        try {
            HttpServletRequest r = (HttpServletRequest)this.asyncContext.getRequest();
            Cookie[] cookies = r.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(cookieName)) continue;
                    return cookie;
                }
            }
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        catch (ClassCastException | IllegalStateException | NullPointerException ex) {
            LOG.severe(ex.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public String getCookieValue(String cookieName) throws WebApplicationException {
        return this.getCookie(cookieName).getValue();
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + Objects.hashCode(this.asyncContext);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SseSession other = (SseSession)obj;
        return this.asyncContext.equals(other.asyncContext);
    }

    public String toString() {
        return "SseSession{asyncContext=" + this.asyncContext + '}';
    }
}

