/*
 * Decompiled with CFR 0.152.
 */
package me.busr.jesse;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import me.busr.jesse.SseEventBuilder;
import me.busr.jesse.SseSession;

class SseSessionKeepAlive {
    private static final ScheduledExecutorService KEEPALIVE_SERVIE = Executors.newScheduledThreadPool(1);
    private static final Logger LOG = Logger.getLogger(SseSessionKeepAlive.class.getName());
    private static long interval = 120L;
    private static volatile Set<SseSession> SESSIONS = ConcurrentHashMap.newKeySet();

    SseSessionKeepAlive() {
    }

    protected static void addSession(SseSession session) {
        SESSIONS.add(session);
    }

    protected static void removeSession(SseSession session) {
        SESSIONS.remove(session);
    }

    protected static void start() {
        KEEPALIVE_SERVIE.scheduleAtFixedRate(new KeepaliveRunner(), 0L, interval, TimeUnit.SECONDS);
        LOG.info("Using session Keep-Alive");
    }

    protected static void setInterval(long interval) {
        SseSessionKeepAlive.interval = interval;
    }

    private static class KeepaliveRunner
    implements Runnable {
        private KeepaliveRunner() {
        }

        @Override
        public void run() {
            SESSIONS.forEach(session -> session.pushEvent(new SseEventBuilder().event("ping").data("Keep-Alive").build()));
        }
    }
}

