/*
 * Decompiled with CFR 0.152.
 */
package me.busr.jesse;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.WebApplicationException;
import me.busr.jesse.SseEvent;
import me.busr.jesse.SseSession;

public abstract class SseSessionManager {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();

    public static final ExecutorService getExecutor() {
        return EXECUTOR;
    }

    public static void pushEvent(SseSession session, SseEvent event) {
        if (session != null && event != null) {
            SseSessionManager.getExecutor().submit(() -> session.pushEvent(event));
        }
    }

    public static void broadcastEvent(SseSession[] sessions, SseEvent event) {
        if (sessions != null && event != null) {
            SseSessionManager.getExecutor().submit(() -> {
                for (SseSession session : sessions) {
                    session.pushEvent(event);
                }
            });
        }
    }

    public static void broadcastEvent(Set<SseSession> sessions, SseEvent event) {
        if (sessions != null && event != null) {
            SseSessionManager.getExecutor().submit(() -> sessions.forEach(session -> session.pushEvent(event)));
        }
    }

    public static void broadcastEvent(List<SseSession> sessions, SseEvent event) {
        if (sessions != null && event != null) {
            SseSessionManager.getExecutor().submit(() -> sessions.forEach(session -> session.pushEvent(event)));
        }
    }

    public abstract void onClose(SseSession var1) throws WebApplicationException;

    public abstract void onOpen(SseSession var1) throws WebApplicationException;

    public abstract void onError(SseSession var1);
}

