package me.chatgame.voip;

import java.io.RandomAccessFile;
import java.util.Arrays;

import me.chatgame.voip.VoipAudioIO.AUDIO_DEVICE_TYPE;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.os.Build;
import android.os.Process;

public class VoipAudioDeviceJava extends VoipAudioDevice {

	private AudioTrack audioTrack = null;
	private ThreadPlaying audioPlayerThread = null;
	private boolean isTheadPlaying = false;

	private AudioRecord audioRecord = null;
	private ThreadRecording audioRecorderThread = null;
	private long recordTimes = 0;
	private long playTimes = 0;

	@Override
	public AUDIO_DEVICE_TYPE getDeviceType() {
		return AUDIO_DEVICE_TYPE.JAVA;
	}

	private native int getAudioData(byte[] buf, int len, int sampleRate);

	private native void setAudioData(byte[] buf, int len, int sampleRate);

	private byte[] localFileCache = null;
	private int localFileReadIndex = 0;
	private int localFileCacheSize = 0;

	@Override
	public int doStartPlay(VoipAudioDeviceCallback callback) {

		if (!this.isPlayerInit) {
			int bufferSizeInBytes = AudioTrack.getMinBufferSize(
					this.playerSampleRateInHz, AudioFormat.CHANNEL_OUT_MONO,
					AudioFormat.ENCODING_PCM_16BIT);
			int maxBufferSize = bufferSizeInBytes * 2;
			if (config.vendor.equals("Xiaomi") && getAudioIoType() == VoipAudioIO.AUDIO_IO_TYPE.VOIP) {
				maxBufferSize = bufferSizeInBytes * 5;
			}


			try {

				if(Build.VERSION.SDK_INT >= 24) {//TODO Android 7.0
					AudioAttributes audioAttributes = new AudioAttributes.Builder()
                            .setLegacyStreamType(this.playerStreamType)
                            //.setFlags(AudioAttributes.FLAG_LOW_LATENCY)  //Added in API level 24
                            .setUsage(AudioAttributes.USAGE_VOICE_COMMUNICATION)
                            .setContentType(AudioAttributes.CONTENT_TYPE_SPEECH).build();
                    AudioFormat audioFormat = new AudioFormat.Builder()
                            .setChannelMask(0x01)
                            .setEncoding(AudioFormat.ENCODING_PCM_16BIT)
                            .setSampleRate(this.playerSampleRateInHz).build();

					this.audioTrack = new AudioTrack(audioAttributes,
                            audioFormat, maxBufferSize,
							AudioTrack.MODE_STREAM,0);

				} else {
					this.audioTrack = new AudioTrack(this.playerStreamType,
							this.playerSampleRateInHz,
							AudioFormat.CHANNEL_OUT_MONO,
							AudioFormat.ENCODING_PCM_16BIT, maxBufferSize,
							AudioTrack.MODE_STREAM);

				}



				this.isPlayerInit = true;
			} catch (IllegalArgumentException e) {
				VoipLog.e("[AudioIO] create AudioTrack failed.");
				if (this.audioCallback != null) {
					this.audioCallback.audioNotification(-2);
				}
				return -2;
			}
		} else {
			VoipLog.w("[AudioIO] AudioTrack is already init.");
		}

		if (!this.isPlaying) {
			if (AudioTrack.STATE_INITIALIZED == audioTrack.getState()
					&& audioTrack.getPlayState() != AudioTrack.PLAYSTATE_PLAYING) {
				this.audioTrack.play();
                                //we should use a new thread for playing,it will cause time out in linux driver if we
                                //use the record thread for playing.
				this.audioPlayerThread = new ThreadPlaying();
				this.audioPlayerThread.start();
				this.isTheadPlaying = true;
				this.isPlaying = true;
			} else {
				stopPlay(false);
				VoipLog.e("[AudioIO] AudioTrack start play failed");
				if (this.audioCallback != null) {
					this.audioCallback.audioNotification(-2);
				}
				return -2;
			}
		} else {
			VoipLog.w("[AudioIO] AudioTrack is already playing.");
		}

		return 0;
	}

	@Override
	public int doStopPlay(boolean byAudioFocus) {
		if (this.isPlaying) {
			if(this.isTheadPlaying) {
				this.audioPlayerThread.toStop = true;
				if (Thread.currentThread() != this.audioPlayerThread) {
					try {
						this.audioPlayerThread.join();
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
			this.audioPlayerThread = null;
			this.isTheadPlaying = false;
			this.audioTrack.stop();
			this.isPlaying = false;
			this.playTimes = 0;
			VoipLog.d("VoipAudioDeviceJava doStopPlay");
		}

		if (this.isPlayerInit) {
			this.audioTrack.release();
			this.audioTrack = null;
			this.isPlayerInit = false;
		}

		return 0;
	}

	@Override
	public int doStartRecord() {
		if (!this.isRecorderInit) {
			int bufferSizeInBytes = AudioRecord.getMinBufferSize(
					this.recorderSampleRateInHz, AudioFormat.CHANNEL_IN_MONO,
					AudioFormat.ENCODING_PCM_16BIT);
			try {
				VoipLog.d("recorderAudioSource =" + this.recorderAudioSource);
				if (config.vendor.equals("Xiaomi") && getAudioIoType() == VoipAudioIO.AUDIO_IO_TYPE.VOIP) {
					this.audioRecord = new AudioRecord(this.recorderAudioSource,
							this.recorderSampleRateInHz,
							AudioFormat.CHANNEL_IN_MONO,
							AudioFormat.ENCODING_PCM_16BIT, bufferSizeInBytes * 2);
				}else{
					this.audioRecord = new AudioRecord(this.recorderAudioSource,
							this.recorderSampleRateInHz,
							AudioFormat.CHANNEL_IN_MONO,
							AudioFormat.ENCODING_PCM_16BIT, bufferSizeInBytes * 5);
				}
				this.isRecorderInit = true;
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
				VoipLog.e("[AudioIO] create AudioRecord failed.");
				if (this.audioCallback != null) {
					this.audioCallback.audioNotification(-2);
				}
				return -2;
			}
		} else {
			VoipLog.w("[AudioIO] AudioRecord is already init.");
		}

		if (!this.isRecording) {
			if (AudioRecord.STATE_INITIALIZED == audioRecord.getState()) {
				this.audioRecorderThread = new ThreadRecording();
				this.audioRecord.startRecording();
				this.audioRecorderThread.start();
				this.isRecording = true;

			} else {
				stopRecord();
				VoipLog.e("[AudioIO] AudioRecord start record failed");
				if (this.audioCallback != null) {
					this.audioCallback.audioNotification(-2);
				}
				return -2;
			}
		} else {
			VoipLog.w("[AudioIO] AudioRecord is already recording.");
		}
		return 0;
	}

	@Override
	public int doStopRecord() {
		if (this.isRecording) {
			this.audioRecorderThread.toStop = true;
			if (Thread.currentThread() != this.audioRecorderThread) {
				try {
					this.audioRecorderThread.join();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			this.audioRecorderThread = null;
			this.audioRecord.stop();
			this.isRecording = false;
			this.recordTimes = 0;
			VoipLog.d("VoipAudioDeviceJava doStopRecord");
		}

		if (this.isRecorderInit) {
			this.audioRecord.release();
			this.audioRecord = null;
			this.isRecorderInit = false;
		}
		return 0;
	}

	@Override
	public void setLocalTestFile(boolean isTest, String dataFilePath) {
		this.isLocalFileTest = isTest;
		if(this.isLocalFileTest) {
			localFileCache = new byte[1024000];
			try {
				RandomAccessFile file = new RandomAccessFile(dataFilePath, "r");
				byte[] buf = new byte[320];
				int index = 0;
				while( file.read(buf, 0, 320) > 0 ) {
					System.arraycopy(buf, 0, localFileCache, index * 320, 320);
					index++;
				}
				localFileCacheSize = index * 320;
				VoipLog.d("[VoipAudioDeviceJava][setLocalFileTest] load file to cache done, size = " + localFileCacheSize);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private int getLocalAudioData(byte[] pcm, int size) {
		System.arraycopy(localFileCache, localFileReadIndex, pcm, 0, size);
		localFileReadIndex += size;
		if(localFileReadIndex > localFileCacheSize) {
			localFileReadIndex = 0;//loop
		}
		return size;
	}

	class ThreadPlaying extends Thread {
		public volatile boolean toStop = false;

		public void run() {
			setName("Java ThreadPlaying");
			Process.setThreadPriority(Process.THREAD_PRIORITY_URGENT_AUDIO);

			byte[] pcmData = new byte[VoipAudioDeviceJava.this.playerFrameSize];

			while (!toStop) {
				int readSize = 0;
				if(isLocalFileTest) {
					readSize = getLocalAudioData(pcmData,
							VoipAudioDeviceJava.this.playerFrameSize);
				} else {
					readSize = VoipAudioDeviceJava.this.getAudioData(pcmData,
							VoipAudioDeviceJava.this.playerFrameSize,
							VoipAudioDeviceJava.this.playerSampleRateInHz);
				}


				if (VoipAudioDeviceJava.this.playerFrameSize != readSize) {
					Arrays.fill(pcmData, (byte) 0);
				}
				VoipAudioDeviceJava.this.audioTrack.write(pcmData, 0, readSize);
				playTimes++;
				if(playTimes > 500) {
					VoipLog.d("[VoipAudioDeviceJava] ThreadPlaying running playerFrameSize= " + playerFrameSize +",readSize=" + readSize);
					playTimes = 0;
				}
			}
		}
	}

	class ThreadRecording extends Thread {
		public volatile boolean toStop = false;
		public boolean isSendError = false;

		public void run() {
			setName("Java ThreadRecording");
			Process.setThreadPriority(Process.THREAD_PRIORITY_URGENT_AUDIO);

			byte[] pcmData = new byte[VoipAudioDeviceJava.this.recorderFrameSize];
			int recordIndex = 0;
			int allZeroFrames = 0;
			boolean needDetectAllZero = true;

			if(!ifNeedDetectZero) {
				needDetectAllZero = false;
			}

			//Enable AEC process
			if( Build.VERSION.SDK_INT >= 16) {
				if(AcousticEchoCanceler.isAvailable()) {
					AcousticEchoCanceler aec = AcousticEchoCanceler.create(VoipAudioDeviceJava.this.audioRecord.getAudioSessionId());
					if(aec != null) {
						AudioEffect.Descriptor descriptor = aec.getDescriptor();
						VoipLog.d("AcousticEchoCanceler name: " + descriptor.name + ", " + "implementor: " + descriptor.implementor + ", " + "uuid: " + descriptor.uuid);
						int ret = aec.setEnabled(true);
						if(ret != 0) {
							VoipLog.d("But.. SET AEC failed");
						}

					}
				}
			}

			while (!toStop) {

                                    if(!isTheadPlaying && VoipAudioDeviceJava.this.audioTrack != null) {
					int readSize = 0;
					if(isLocalFileTest) {
						readSize = getLocalAudioData(pcmData,
								VoipAudioDeviceJava.this.playerFrameSize);
					} else {
						readSize = VoipAudioDeviceJava.this.getAudioData(pcmData,
								VoipAudioDeviceJava.this.playerFrameSize,
								VoipAudioDeviceJava.this.playerSampleRateInHz);
					}
					if (VoipAudioDeviceJava.this.playerFrameSize != readSize) {
						Arrays.fill(pcmData, (byte) 0);
					}

					if(VoipAudioDeviceJava.this.audioTrack != null && VoipAudioDeviceJava.this.audioTrack.getPlayState() == AudioTrack.PLAYSTATE_PLAYING) {
						VoipAudioDeviceJava.this.audioTrack.write(pcmData, 0, readSize);
					}

				}
				int readLen = VoipAudioDeviceJava.this.audioRecord.read(
						pcmData, 0, VoipAudioDeviceJava.this.recorderFrameSize);



				recordTimes++;
				if(recordTimes > 500) {
					VoipLog.d("[VoipAudioDeviceJava] ThreadRecording running recorderFrameSize= " + recorderFrameSize +",readLen=" + readLen);
					recordTimes = 0;
				}
				if (VoipAudioDeviceJava.this.recorderFrameSize == readLen) {
					VoipAudioDeviceJava.this.setAudioData(pcmData, readLen,
							VoipAudioDeviceJava.this.playerSampleRateInHz);

					if (needDetectAllZero && recordIndex++ > 500 ) {
						boolean allZero = true;
						for (int i = 0; i < readLen; i++) {
							if (0 != pcmData[i]) {
								allZero = false;
								needDetectAllZero = false;
								allZeroFrames = 0;
								break;
							}
						}
						if (allZero) {
							allZeroFrames++;
						}
					}
				} else {
					allZeroFrames++;
				}

				if (allZeroFrames >= 300
						|| AudioRecord.ERROR_INVALID_OPERATION == readLen) {
					if (VoipAudioDeviceJava.this.audioCallback != null) {
						if (!isSendError) {
							isSendError = true;
							VoipAudioDeviceJava.this.audioCallback
									.audioNotification(-4);
						}
					}
				}

			}
		}
	}

}
