package me.chatgame.voip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import me.chatgame.voip.VoipAudioIO.AUDIO_DEVICE_TYPE;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;

public class VoipAudioDeviceMediaPlayer extends VoipAudioDevice {

	private MediaPlayer mediaPlayer = null;
	private volatile int playedPosition = 0;

	private Uri uri;
	private boolean repeat;


	@Override
	public AUDIO_DEVICE_TYPE getDeviceType() {
		return AUDIO_DEVICE_TYPE.MEDIA_PLAYER;
	}

	@Override
	public int doStartPlay(final VoipAudioDeviceCallback callback) {
		if (!this.isPlayerInit) {
			this.mediaPlayer = new MediaPlayer();
			this.mediaPlayer.setAudioStreamType(this.getPlayerStreamType());
			this.isPlayerInit = true;
		}

		File file = new File(this.uri.getPath());
		FileInputStream is = null;
		try {
			is = new FileInputStream(file);
			this.mediaPlayer.setDataSource(is.getFD());
			this.mediaPlayer.setLooping(this.repeat);
			this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
				@Override
				public void onCompletion(MediaPlayer mediaPlayer) {
					if (!mediaPlayer.isLooping()) {
						if (callback != null) {
							VoipLog.d("[VoipAudioDeviceMediaPlayer][startPlay] setOnCompletionListener onCompletion");
							callback.onPlayFinished();
						}
					}
				}
			});

			this.mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener() {
				@Override
				public boolean onError(MediaPlayer mediaPlayer, int i, int i1) {
					VoipLog.e("[VoipAudioDeviceMediaPlayer][MediaPlayer.OnErrorListener] " + i + ", " + i1);
					return false;
				}
			});

			this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
				@Override
				public void onPrepared(MediaPlayer mp) {
					VoipLog.d("[VoipAudioDeviceMediaPlayer][startPlay] onPrepared");
				}
			});

			this.mediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener() {
				@Override
				public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
					VoipLog.d("[VoipAudioDeviceMediaPlayer][startPlay] onVideoSizeChanged");
				}
			});

			this.mediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener() {
				@Override
				public void onSeekComplete(MediaPlayer mp) {
					VoipLog.d("[VoipAudioDeviceMediaPlayer][startPlay] onSeekComplete");
				}
			});

			this.mediaPlayer.prepare();
			this.mediaPlayer.start();
			this.isPlaying = true;

			if (this.isResumePlaying) {
				this.mediaPlayer.seekTo(this.playedPosition);
			}

		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalStateException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (is != null) {
				try {
					is.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return 0;
	}

	@Override
	public int doStopPlay(boolean byAudioFocus) {
		if (this.isPlaying) {
			this.mediaPlayer.pause();
		}

		if(this.mediaPlayer!= null) {
			this.mediaPlayer.setOnCompletionListener(null);
		}

		if (this.isResumePlaying) {
			if(this.mediaPlayer!= null) {
				this.playedPosition = this.mediaPlayer.getCurrentPosition();
			}

		} else {
			this.uri = null;
			this.repeat = false;
			this.playedPosition = 0;
		}

		if (this.isPlaying) {
			this.mediaPlayer.stop();
			this.mediaPlayer.release();
			this.isPlaying = false;
			this.isPlayerInit = false;

		}

		this.mediaPlayer = null;

		return 0;
	}

	@Override
	public int doStartRecord() {
		VoipLog.w("[VoipAudioDeviceMediaPlayer][doStartRecord] not support");
		return 0;
	}

	@Override
	public int doStopRecord() {
		VoipLog.w("[VoipAudioDeviceMediaPlayer][doStopRecord] not support");
		return 0;
	}

	@Override
	public void setLocalTestFile(boolean isTest, String dataFilePath) {
		this.uri =Uri.fromFile(new File(dataFilePath));
		this.repeat = false;
	}


	public void setMp3File(Uri uri, boolean repeat) {
		this.uri = uri;
		this.repeat = repeat;
	}

}
