package me.chatgame.voip;

import me.chatgame.voip.VoipAudioIO.AUDIO_DEVICE_TYPE;

public class VoipAudioDeviceOpenSL extends VoipAudioDevice {


	private native boolean OpenSLInit(int recordingPreset, int playingStreamType);

	private native void OpenSLUninit();

	private native void OpenSLStartPlaying();

	private native void OpenSLStopPlaying();

	private native void OpenSLStartRecording();

	private native void OpenSLStopRecording();

	private native void OpenSLSetLocalFileTest(boolean isTest, String path);


	@Override
	public AUDIO_DEVICE_TYPE getDeviceType() {
		return AUDIO_DEVICE_TYPE.OPENSL;
	}

	@Override
	public synchronized int doStartPlay(final VoipAudioDeviceCallback callback) {
		if (!this.isPlayerInit) {
			if (OpenSLInit(this.recorderAudioSource, this.playerStreamType)) {
				this.isPlayerInit = true;
				this.isRecorderInit = true;
			} else {
				stopPlay(false);
				VoipLog.e("[AudioIO] OpenSL init failed when startPlay");
				if (this.audioCallback != null) {
					this.audioCallback.audioNotification(-2);
				}
			}
		}
		if (this.isPlayerInit) {
			this.OpenSLStartPlaying();
			this.isPlaying = true;
		}
		return 0;
	}

	@Override
	public synchronized int doStopPlay(boolean byAudioFocus) {
		if (this.isPlaying) {
			this.OpenSLStopPlaying();
			this.isPlaying = false;
		}
		if (!this.isRecording) {
			this.OpenSLUninit();
			this.isRecorderInit = false;
			this.isPlayerInit = false;
		}
		return 0;
	}

	@Override
	public synchronized int doStartRecord() {
		if (!this.isRecorderInit) {
			if (OpenSLInit(this.recorderAudioSource, this.playerStreamType)) {
				this.isPlayerInit = true;
				this.isRecorderInit = true;
			} else {
				stopRecord();
				VoipLog.e("[AudioIO] OpenSL init failed when startRecord");
				if (this.audioCallback != null) {
					this.audioCallback.audioNotification(-2);
				}
			}
		}
		if (this.isRecorderInit) {
			this.OpenSLStartRecording();
			this.isRecording = true;
		}
		return 0;
	}

	@Override
	public synchronized int doStopRecord() {
		if (this.isRecording) {
			this.OpenSLStopRecording();
			this.isRecording = false;
		}
		if (!this.isPlaying) {
			this.OpenSLUninit();
			this.isRecorderInit = false;
			this.isPlayerInit = false;
		}
		return 0;
	}

	@Override
	public void setLocalTestFile(boolean isTest, String dataFilePath) {
		this.OpenSLSetLocalFileTest(isTest, dataFilePath);
	}

	public void jniCallback(int code) {
		if(this.audioCallback != null /*&& ifNeedDetectZero*/) {//opensl must detect empty audio
			this.audioCallback.audioNotification(code);
		}
	}

}
