package me.chatgame.voip;

import android.media.AudioManager;
import android.media.MediaRecorder;

import java.util.concurrent.locks.Lock;

import me.chatgame.voip.VoipAndroid.AudioCallback;
import me.chatgame.voip.VoipAudioIO.AUDIO_IO_TYPE;

/**
 * Not thread safe
 *
 * @author chenxy
 *
 */
public abstract class VoipAudioDevice {

//	private static final int SAMPLE_RATE = 16000;
//	private static final int FRAME_SIZE = 320;

	private static final int SAMPLE_RATE = 48000;
	private static final int FRAME_SIZE = 960;

	private static final int HD_SAMPLE_RATE = 48000;// TODO 44100;
	private static final int HD_FRAME_SIZE = 960;// TODO 882;

	public static final int AUDIO_DEVICE_NO_ERROR = 0;

	protected AUDIO_IO_TYPE audioIoType = AUDIO_IO_TYPE.NONE;

	protected boolean isEarpiece = false;
	protected boolean isBluetooth = false;

	protected volatile boolean isPlayerInit = false;
	protected volatile boolean isRecorderInit = false;
	protected volatile boolean isPlaying = false;
	protected volatile boolean isRecording = false;

	protected volatile boolean isPause = false;
	protected volatile boolean isResumePlaying = false;
	protected volatile boolean isResumeRecording = false;

	protected int recorderAudioSource;
	protected int recorderSampleRateInHz;
	protected int recorderFrameSize;

	protected int playerStreamType;
	protected int playerSampleRateInHz;
	protected int playerFrameSize;

	protected AudioCallback audioCallback = null;

	protected boolean isLocalFileTest = false;

	private static VoipAudioDevice instance = null;

	protected boolean ifNeedDetectZero = false;

	protected static VoipConfig config;

	public VoipAudioDevice() {
	}


	public interface VoipAudioDeviceCallback {
		public void onPlayFinished();
	}


	public static synchronized VoipAudioDevice getInstance(AUDIO_IO_TYPE audioIoType, VoipConfig config, boolean isEarpiece, boolean isBluetooth) {

		VoipAudioIO.AUDIO_DEVICE_TYPE deviceType = VoipAudioIO.AUDIO_DEVICE_TYPE.NONE;
		if (audioIoType == AUDIO_IO_TYPE.VOIP) {
			deviceType = config.audioDevice == VoipConfig.DEVICE_OPENSL ? VoipAudioIO.AUDIO_DEVICE_TYPE.OPENSL
					: VoipAudioIO.AUDIO_DEVICE_TYPE.JAVA;
		} else if (audioIoType == AUDIO_IO_TYPE.AUDIO_MESSAGE || audioIoType == AUDIO_IO_TYPE.VIDEO_MESSAGE) {
			deviceType = VoipAudioIO.AUDIO_DEVICE_TYPE.JAVA;
		} else if (audioIoType == AUDIO_IO_TYPE.RINGTONE || audioIoType == AUDIO_IO_TYPE.MESSAGERECV || audioIoType == AUDIO_IO_TYPE.PLAYMUSIC) {
			deviceType = VoipAudioIO.AUDIO_DEVICE_TYPE.MEDIA_PLAYER;
		}

		if(instance != null) {
			if(instance.audioIoType == audioIoType &&
					instance.getDeviceType() == deviceType) {
			} else {
				instance.stopRecord();
				instance.stopPlay(false);
				instance = null;
				VoipLog.d("[VoipAudioDevice][getInstance] release instance");
			}
		}

		if (instance == null) {
			if (deviceType == VoipAudioIO.AUDIO_DEVICE_TYPE.JAVA) {
				instance = new VoipAudioDeviceJava();
			} else if (deviceType == VoipAudioIO.AUDIO_DEVICE_TYPE.OPENSL) {
				instance = new VoipAudioDeviceOpenSL();
			} else if (deviceType == VoipAudioIO.AUDIO_DEVICE_TYPE.MEDIA_PLAYER) {
				instance = new VoipAudioDeviceMediaPlayer();
			}
		}


		instance.recorderAudioSource = getRecorderAudioSource(deviceType, audioIoType, config, isEarpiece, isBluetooth);
		instance.playerStreamType = getPlayerStreamType(deviceType, audioIoType, config, isEarpiece, isBluetooth);

		if(audioIoType == AUDIO_IO_TYPE.AUDIO_MESSAGE || audioIoType == AUDIO_IO_TYPE.VIDEO_MESSAGE) {//TODO HD AUDIO
			instance.recorderSampleRateInHz = config.hardwareSampleRate;
			instance.recorderFrameSize = config.getFrameSize(config.hardwareSampleRate);

			instance.playerSampleRateInHz = config.hardwareSampleRate;
			instance.playerFrameSize = config.getFrameSize(config.hardwareSampleRate);
		} else {
			instance.recorderSampleRateInHz = config.hardwareSampleRate;
			instance.recorderFrameSize = config.getFrameSize(config.hardwareSampleRate);

			instance.playerSampleRateInHz = config.hardwareSampleRate;;
			instance.playerFrameSize = config.getFrameSize(config.hardwareSampleRate);

		}
		instance.audioIoType = audioIoType;
		instance.isEarpiece = isEarpiece;
		instance.isBluetooth = isBluetooth;

		if(deviceType == VoipAudioIO.AUDIO_DEVICE_TYPE.OPENSL) {
			instance.ifNeedDetectZero = true;
		}

		VoipLog.d("[VoipAudioDevice] [getInstance] " + instance.toString());


		return instance;
	}


	public void setAudioCallback(AudioCallback audioCallback) {
		this.audioCallback = audioCallback;
	}

	public AUDIO_IO_TYPE getAudioIoType() {
		return instance.audioIoType;
	}


	public abstract VoipAudioIO.AUDIO_DEVICE_TYPE getDeviceType();

	public abstract int doStartPlay(final VoipAudioDeviceCallback callback);

	public abstract int doStopPlay(boolean byAudioFocus);

	public abstract int doStartRecord();

	public abstract int doStopRecord();

	public int startPlay(final VoipAudioDeviceCallback callback) {
		VoipLog.d("[VoipAudioDevice][startPlay] start");
		int ret = this.doStartPlay(callback);
		VoipLog.d("[VoipAudioDevice][startPlay] finished");
		return ret;
	}

	public int stopPlay(boolean byAudioFocus) {
		VoipLog.d("[VoipAudioDevice][stopPlay] start");
		int ret = this.doStopPlay(byAudioFocus);
		this.isResumePlaying = false;
		this.isPause = false;
		VoipLog.d("[VoipAudioDevice][stopPlay] finished");
		return ret;
	}

	public int startRecord() {
		VoipLog.d("[VoipAudioDevice][startRecord] start");
		int ret = this.doStartRecord();
		VoipLog.d("[VoipAudioDevice][startRecord] finished");
		return ret;
	}

	public int stopRecord() {
		VoipLog.d("[VoipAudioDevice][stopRecord] start");
		int ret = this.doStopRecord();
		this.isResumeRecording = false;
		this.isPause = false;
		VoipLog.d("[VoipAudioDevice][stopRecord] finished");
		return ret;
	}

	public void pause(boolean byAudioFocus) {
		if(!this.isPause) {
			VoipLog.d("[VoipAudioDevice][pause] start");
			this.isResumePlaying = this.isPlaying;
			this.isResumeRecording = this.isRecording;
			this.doStopRecord();
			this.doStopPlay(byAudioFocus);
			this.isPause = true;
			VoipLog.d("[VoipAudioDevice][pause] finished");
		} else {
			VoipLog.w("[VoipAudioDevice][pause] is paused");
		}
	}

	public void resume(final VoipAudioDeviceCallback callback) {
		if(this.isPause) {
			VoipLog.d("[VoipAudioDevice][resume] start");
			if (this.isResumePlaying) {
				this.doStartPlay(callback);
			}
			if (this.isResumeRecording) {
				this.doStartRecord();
			}
			this.isResumePlaying = false;
			this.isResumeRecording = false;

			this.isPause = false;
			VoipLog.d("[VoipAudioDevice][resume] finished");
		} else {
			VoipLog.w("[VoipAudioDevice][resume] is resumed");
		}

	}

	public abstract void setLocalTestFile(boolean isTest, String dataFilePath);

	private static int getOpenSLRecordingPreset(AUDIO_IO_TYPE ioType, VoipConfig config, boolean useEarpiece, boolean bluetooth) {
		// 1: SL_ANDROID_RECORDING_PRESET_GENERIC
		// 2: SL_ANDROID_RECORDING_PRESET_CAMCORDER
		// 3: SL_ANDROID_RECORDING_PRESET_VOICE_RECOGNITION
		// 4: SL_ANDROID_RECORDING_PRESET_VOICE_COMMUNICATION
		if (bluetooth) {
			if(ioType == AUDIO_IO_TYPE.VOIP) {
				//return 4;
				return 1;
			} else {
				return 1;
			}
			
		} else if (useEarpiece) {
			if(config.product.equals("MI 2S"))
				return 3;
			else
				return 4;
		}
		return config.audioRecordingPreset;
	}

	private static int getOpenSLPlayingStreamType(AUDIO_IO_TYPE ioType, int configStreamType, boolean useEarpiece, boolean bluetooth) {
		// 0: SL_ANDROID_STREAM_VOICE
		// 3: SL_ANDROID_STREAM_MEDIA
		if (bluetooth) {
			if(ioType == AUDIO_IO_TYPE.VOIP) {
				//return 0;
				return 3;
			} else {
				return 3;
			}
			
		} else if (useEarpiece) {
			return 0;
		}
		return configStreamType;
	}

	private static int getAudioSource(AUDIO_IO_TYPE ioType, int configRecordingPreset, boolean useEarpiece, boolean bluetooth) {
		// MediaRecorder.AudioSource.DEFAULT;
		// MediaRecorder.AudioSource.MIC;
		// MediaRecorder.AudioSource.VOICE_UPLINK;
		// MediaRecorder.AudioSource.VOICE_DOWNLINK;
		// MediaRecorder.AudioSource.VOICE_CALL;
		// MediaRecorder.AudioSource.CAMCORDER;
		// MediaRecorder.AudioSource.VOICE_RECOGNITION;
		// MediaRecorder.AudioSource.VOICE_COMMUNICATION;
		// MediaRecorder.AudioSource.REMOTE_SUBMIX;
		if (bluetooth) {
			if(ioType == AUDIO_IO_TYPE.VOIP) {
				return  MediaRecorder.AudioSource.VOICE_COMMUNICATION;
				//return MediaRecorder.AudioSource.DEFAULT;
			} else {
				return MediaRecorder.AudioSource.DEFAULT;
			}
		} else if (useEarpiece) {
			return MediaRecorder.AudioSource.VOICE_COMMUNICATION;
		}
		return configRecordingPreset;
	}

	private static int getStreamType(AUDIO_IO_TYPE ioType, int configStreamType, boolean useEarpiece, boolean bluetooth) {
            // 0: AudioManager.STREAM_VOICE_CALL;
            // 1: AudioManager.STREAM_SYSTEM;
            // 2: AudioManager.STREAM_RING;
            // 3: AudioManager.STREAM_MUSIC;
            // 4: AudioManager.STREAM_ALARM;
            // 5: AudioManager.STREAM_NOTIFICATION;
            // 8: AudioManager.STREAM_DTMF;
            if(ioType == AUDIO_IO_TYPE.RINGTONE) {
                if(config.product.equals("MI 5")) {
                    return AudioManager.STREAM_RING;
               }else {
                   return AudioManager.STREAM_MUSIC;
               }
            }else if (bluetooth) {
                if(ioType == AUDIO_IO_TYPE.VOIP) {
                    return AudioManager.STREAM_VOICE_CALL;
                } else {
                    return AudioManager.STREAM_MUSIC;
                }
            } else if (useEarpiece) {
                return AudioManager.STREAM_VOICE_CALL;
            } else {
                if (ioType == AUDIO_IO_TYPE.AUDIO_MESSAGE
                        || ioType == AUDIO_IO_TYPE.VIDEO_MESSAGE
                        || ioType == AUDIO_IO_TYPE.MESSAGERECV
                        || ioType == AUDIO_IO_TYPE.PLAYMUSIC) {
                    return AudioManager.STREAM_MUSIC;
                }
            }
            return configStreamType;
	}

	private static int getRecorderAudioSource(VoipAudioIO.AUDIO_DEVICE_TYPE deviceType, AUDIO_IO_TYPE ioType, VoipConfig config, boolean useEarpiece, boolean bluetooth) {
		if (ioType == AUDIO_IO_TYPE.VOIP) {
			if (deviceType == VoipAudioIO.AUDIO_DEVICE_TYPE.JAVA) {
				return getAudioSource(ioType, config.audioRecordingPreset, useEarpiece, bluetooth);
			} else if (deviceType == VoipAudioIO.AUDIO_DEVICE_TYPE.OPENSL) {
				return getOpenSLRecordingPreset(ioType, config, useEarpiece, bluetooth);
			} else {
				return MediaRecorder.AudioSource.DEFAULT;
			}
		} else {
			return MediaRecorder.AudioSource.DEFAULT;
		}
	}

	private static int getPlayerStreamType(VoipAudioIO.AUDIO_DEVICE_TYPE deviceType, AUDIO_IO_TYPE ioType, VoipConfig config, boolean useEarpiece, boolean bluetooth) {
//		if (ioType == VoipAudioIO.AUDIO_IO_TYPE.VOIP) {
/*			if (deviceType == VoipAudioIO.AUDIO_DEVICE_TYPE.JAVA) {
				return getStreamType(ioType, config.audioStreamType, useEarpiece, bluetooth);
			} else if (deviceType == VoipAudioIO.AUDIO_DEVICE_TYPE.OPENSL) {
				return getOpenSLPlayingStreamType(ioType, config.audioStreamType, useEarpiece, bluetooth);
			} else {
				return AudioManager.STREAM_MUSIC;
			}
//		} else {
//			return AudioManager.STREAM_MUSIC;
//		}*/
		if (deviceType == VoipAudioIO.AUDIO_DEVICE_TYPE.OPENSL) {
			return getOpenSLPlayingStreamType(ioType, config.audioStreamType, useEarpiece, bluetooth);
		} else {
			return getStreamType(ioType, config.audioStreamType, useEarpiece, bluetooth);
		}
	}

	public int getPlayerStreamType() {
		return this.playerStreamType;
	}

	@Override
	public String toString() {
		return "VoipAudioDevice{" +
				"audioDeviceType=" + getDeviceType() +
				", audioIoType=" + audioIoType +
				", isEarpiece=" + isEarpiece +
				", isBluetooth=" + isBluetooth +
				", isPlayerInit=" + isPlayerInit +
				", isRecorderInit=" + isRecorderInit +
				", isPlaying=" + isPlaying +
				", isRecording=" + isRecording +
				", recorderAudioSource=" + recorderAudioSource +
				", recorderSampleRateInHz=" + recorderSampleRateInHz +
				", recorderFrameSize=" + recorderFrameSize +
				", playerStreamType=" + playerStreamType +
				", playerSampleRateInHz=" + playerSampleRateInHz +
				", playerFrameSize=" + playerFrameSize +
				'}';
	}
}
