package me.chatgame.voip;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;

import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by xychen on 11/2/15.
 */
public class VoipAudioIO implements VoipAudioManager.VoipAudioFocusChangeCallback, VoipAudioDevice.VoipAudioDeviceCallback{


    private VoipAudioManager audioManager;
    private VoipConfig config;
    private VoipAudioDevice audioDevice;


    private volatile boolean isPlaying = false;
    private volatile boolean isRecording = false;

    private volatile boolean isUseEarpiece = false;
    private volatile boolean isBluetooth = false;
    private volatile boolean isHandset = false;
    private volatile boolean newEarpieceState;
    private volatile AUDIO_IO_TYPE currentIoType;

    private VoipAndroid.AudioCallback audioCallback = null;

    private volatile boolean isGameMode = false;

    private Activity currentActivity;

    private final Context mContext;

    public interface VoipAudioDataSourceSetter {
        public void doSetDataSource(VoipAudioDevice device);
    }


    interface ClearAudioCacheCallback {
        void onClearAudioCache();
    }

    private ClearAudioCacheCallback clearAudioCacheCallback = null;

    public VoipAudioIO(AudioManager audioManager, VoipConfig config,  final Context context) {
        this.audioManager = new VoipAudioManager(this, audioManager);
        this.config = config;
        VoipAudioDevice.config = config;
        this.audioManager.config = config;
        this.mContext = context;


        boolean hasLowLatencyFeature =
                mContext.getPackageManager().hasSystemFeature(PackageManager.FEATURE_AUDIO_LOW_LATENCY);

//        boolean hasProFeature =
//                mContext.getPackageManager().hasSystemFeature(PackageManager.FEATURE_AUDIO_PRO);

        VoipLog.d("[VoipAudioIO][VoipAudioIO] hasLowLatencyFeature = " + hasLowLatencyFeature);
    }

    void setConfig(VoipConfig config) {
        this.config = config;
        VoipAudioDevice.config = config;
        this.audioManager.config = config;

    }

    public enum AUDIO_IO_TYPE {
        NONE("none"), VOIP("voip"), AUDIO_MESSAGE("audio message"), RINGTONE(
                "ring tone"), VIDEO_MESSAGE("video message"), MESSAGERECV("message recv"),PLAYMUSIC("play music");
        private String type;

        AUDIO_IO_TYPE(String type) {
            this.type = type;
        }

        @Override
        public String toString() {
            return this.type;
        }
    }

    public enum AUDIO_DEVICE_TYPE {
        NONE("none"), JAVA("java"), OPENSL("opensl"), MEDIA_PLAYER(
                "media player");
        private String type;

        AUDIO_DEVICE_TYPE(String type) {
            this.type = type;
        }

        @Override
        public String toString() {
            return this.type;
        }
    }

    private ReentrantLock audioIOLock = new ReentrantLock();

    private void ioLock() {
        audioIOLock.lock();
    }

    private void ioUnlock() {
        audioIOLock.unlock();
    }

    public void resetSpecialAudioDevice(boolean useEarpiece,boolean inAudioCall) {
        VoipLog.d("[VoipAudioIO][resetSpecialAudioDevice] isplaying = " + this.isPlaying + "; inAudioCall = " + inAudioCall);
        ioLock();
        try {
            if(inAudioCall && this.audioManager.isBluetoothConnected()) {
                VoipLog.d("[VoipAudioIO][resetSpecialAudioDevice] reset bluetooth");
                this.audioManager.setScoRecordRoute(true);
            }
            if(!inAudioCall && this.isPlaying ) {
                //jinwei it must be reset AudioMode when headset plug-in/out with handset is true or false
                this.audioManager.resetSpecailAudioMode(useEarpiece && !this.audioManager.isHeadsetConnected());
                if (this.audioManager.isBluetoothConnected() || this.audioManager.isHeadsetConnected()) {
                    VoipLog.d("[VoipAudioIO][resetSpecialAudioDevice] resetDevice true");
                    this.audioManager.resetSpecialAudioDevice(true);
                } else {
                    VoipLog.d("[VoipAudioIO][resetSpecialAudioDevice] resetDevice with useEarpiece");
                    this.audioManager.resetSpecialAudioDevice(useEarpiece);
                }
            }
        } finally {
            ioUnlock();
        }
    }

    private void startPlayingProcess(Activity activity, AUDIO_IO_TYPE ioType, VoipAudioDataSourceSetter setter, boolean useEarpiece) {
                //2. set params
                if(activity != null) {
                    this.currentActivity = activity;
                } else {
                    VoipLog.w("[VoipAudioIO][startPlayingProcess] current activity is null, maybe cannot set volume.");
                }
                this.isUseEarpiece = useEarpiece;//if use receiver
                this.isHandset = useEarpiece;//the state of handset only
                if(!this.isUseEarpiece) {
                   this.isUseEarpiece = this.audioManager.isHeadsetConnected(); //if use headset
                }
                this.isBluetooth = this.audioManager.isBluetoothConnected();

                VoipLog.d("[VoipAudioIO][startPlayingProcess] start playing....useEarpiece ="+isUseEarpiece);

                //3. store audio setting
                this.audioManager.storeAudioModeAndRoute();
                this.audioManager.setAudioModeAndRoute(ioType, this.config, this.isUseEarpiece, this.isBluetooth);


                //4. get audio device and set callback
                this.audioDevice = VoipAudioDevice.getInstance(ioType, this.config, isUseEarpiece, this.isBluetooth);
                this.audioDevice.setAudioCallback(this.audioCallback);

                //5. set audio data source if need
                if(setter != null) {
                    setter.doSetDataSource(this.audioDevice);
                }

                //5. start audio device
                //      play audio effect use ringtone need to stop automatic
                if(ioType == AUDIO_IO_TYPE.RINGTONE || ioType == AUDIO_IO_TYPE.MESSAGERECV || ioType ==AUDIO_IO_TYPE.PLAYMUSIC) {
                    this.audioDevice.startPlay(this);
                } else {
                    this.audioDevice.startPlay(null);
                }

                //6. set playing flag and io type
                if (ioType != AUDIO_IO_TYPE.MESSAGERECV) {
                    this.isPlaying = true;
                }
                this.currentIoType = ioType;

                //7. set current activity and set volume control stream type
                if(activity != null) {
                    this.currentActivity.setVolumeControlStream(this.audioDevice.getPlayerStreamType());
                }

                this.audioManager.setAudioIOandStreamType(this.currentIoType,this.audioDevice.getPlayerStreamType());

                VoipLog.d("[VoipAudioIO][startPlayingProcess] start playing finished: mode = " + this.audioManager.getAudioMode() + " , speaker = " + this.audioManager.isSpeakerphoneON() + " , bluetooth = " + this.audioManager.isBluetoothScoON());

    }
    public void startPlaying(Activity activity, AUDIO_IO_TYPE ioType, VoipAudioDataSourceSetter setter, boolean useEarpiece) {
        ioLock();
        if(this.isPlaying && this.currentIoType == ioType) {
            VoipLog.w("[VoipAudioIO][startPlaying] is playing...");
        } else {
            if (this.isPlaying) {
                VoipLog.w("[VoipAudioIO][startPlaying] is playing... (currentIoType=" + this.currentIoType + ", ioType=" + ioType + ", will restart.)");
                this.stopPlaying();
            }
            if(this.audioManager.ifneedrequestAudioFocus(ioType)) {
                VoipLog.d("[VoipAudioIO][startPlaying] needrequeset AudioFocus");
                if(this.audioManager.requestAudioFocus(ioType,this.mContext)) {
                    VoipLog.d("[VoipAudioIO] record got audio focus success.");
                } else {
                    VoipLog.w("[VoipAudioIO][startPlaying] not got audio focus.");
                }
                startPlayingProcess(activity, ioType, setter, useEarpiece);
            } else {
                VoipLog.d("[VoipAudioIO][startPlaying] don't needrequeset AudioFocus");
                startPlayingProcess(activity, ioType, setter, useEarpiece);
            }
        }
        ioUnlock();
    }

    public void stopPlaying() {
        ioLock();
        if(!this.isPlaying && this.currentIoType != AUDIO_IO_TYPE.MESSAGERECV) {
            VoipLog.w("[VoipAudioIO][stopPlaying] is stopped.");
        } else {

            VoipLog.d("[VoipAudioIO][stopPlaying] stop playing....");

            //1. stop audio device
            this.audioDevice.stopPlay(false);

            //2. restore audio setting
            this.audioManager.restoreAudioModeAndRoute();

            //3. abandon audio focus
            if(this.currentIoType != AUDIO_IO_TYPE.MESSAGERECV) {
                VoipLog.d("voip is need abandon");
                this.audioManager.abandonAudioFocus();
            }
            //4. set playing and route flag
            this.isPlaying = false;

            this.isUseEarpiece = false;
            this.isBluetooth = false;

            //5. set volume control activity is null
            this.currentActivity = null;

            //6. check if is recording
            if(this.isRecording) {
            	VoipLog.e("[VoipAudioIO][stopPlaying] call stop playing must after stop recording");
            }

            VoipLog.d("[VoipAudioIO][stopPlaying] stop playing finished.");
        }
        ioUnlock();
    }

    public void startRecording(AUDIO_IO_TYPE ioType) {
        ioLock();
        if(this.isRecording) {
            VoipLog.w("[VoipAudioIO][startRecording] is recording...");
        } else if(ioType == AUDIO_IO_TYPE.VOIP && !this.isPlaying) {
        	VoipLog.w("[VoipAudioIO][startRecording] voip must start playing to set audio mode and get device.");
        } else {
            VoipLog.d("[VoipAudioIO][startRecording] start recording...");
            //1. request audio focus
            if(ioType == AUDIO_IO_TYPE.VOIP) {
                VoipLog.d("[VoipAudioIO] VOIP record no need got audio focus.");
            } else if(this.audioManager.requestAudioFocus(ioType,this.mContext)){
                VoipLog.d("[VoipAudioIO] record got audio focus success.");
            } else{
                VoipLog.w("[VoipAudioIO][startRecording] not got audio focus.");
            }

                if (this.audioManager.isBluetoothConnected() == true) {
                    VoipLog.d("[VoipAudioIO][startRecording] set sco route begin....");
                    this.audioManager.setScoRecordRoute(true);
                }


                //2. get audio device
                this.audioDevice = VoipAudioDevice.getInstance(ioType, this.config, this.audioManager.isHeadsetConnected(), this.audioManager.isBluetoothConnected());
                this.audioDevice.setAudioCallback(this.audioCallback);

                //3. start audio device
                this.audioDevice.startRecord();

                //4. set recording flag and io type
                this.isRecording = true;
                this.currentIoType = ioType;

            VoipLog.d("[VoipAudioIO][startRecording] start recording finished.");
        }
        ioUnlock();
    }

    public void stopRecording() {
        ioLock();
        if(!this.isRecording) {
            VoipLog.w("[VoipAudioIO][stopRecording] is stopped.");
        } else {

            VoipLog.d("[VoipAudioIO][stopRecording] stop recording...");

            //1. stop audio device
            this.audioDevice.stopRecord();
            //2.restore audio routing
            if (this.audioManager.isBluetoothConnected() == true) {
                VoipLog.d("[VoipAudioIO][stopRecording] close sco route begin....");
                this.audioManager.setScoRecordRoute(false);
            }
            //3.abandon audio focus
            if(this.currentIoType != AUDIO_IO_TYPE.VOIP)
                this.audioManager.abandonAudioFocus();

            //3. set playing flag
            this.isRecording = false;

            VoipLog.d("[VoipAudioIO][stopRecording] stop recording finished.");

        }
        ioUnlock();
    }

    private boolean setAudioRouteProcess(boolean useEarpiece, boolean useBluetooth) {
        //1. check if got audio focus
        if(this.audioManager.isGotFocus() && this.audioDevice.isPlaying) {

            VoipLog.d("[VoipAudioIO][setAudioRouteProcess] start set audio route...useEarpiece= "+isUseEarpiece);
            this.isUseEarpiece = useEarpiece;
            //2. pause audio device
            this.audioDevice.pause(false);

            //3. set audio setting
            this.audioManager.setAudioModeAndRoute(this.currentIoType, this.config, useEarpiece, useBluetooth);
            this.audioDevice = VoipAudioDevice.getInstance(this.currentIoType, this.config, useEarpiece, useBluetooth);

            //4. resume audio device
            if(this.currentIoType == AUDIO_IO_TYPE.RINGTONE || this.currentIoType == AUDIO_IO_TYPE.PLAYMUSIC) {
                this.audioDevice.resume(this);
            } else {
                this.audioDevice.resume(null);
            }

            //5. set route use flag
            //this.isUseEarpiece = useEarpiece;
            this.isBluetooth = useBluetooth;

            //6. set volume controller
            if(this.currentActivity != null) {
                this.currentActivity.setVolumeControlStream(this.audioDevice.getPlayerStreamType());
            } else {
                VoipLog.w("[VoipAudioIO][setAudioRouteProcess] current activity is null, maybe cannot set volume.");
            }

            VoipLog.d("[VoipAudioIO][setAudioRouteProcess] start set audio route finished.");

            return true;
        } else {
            VoipLog.w("[VoipAudioIO][setAudioRouteProcess] not got audio focus or not playing.");
            return false;
        }

    }

    /**
     * @param use
     * @return io type if set earpiece success
     */
    public AUDIO_IO_TYPE setUseEarpiece(final boolean use) {
        AUDIO_IO_TYPE ret = AUDIO_IO_TYPE.NONE;
        ioLock();
        VoipLog.d("[VoipAudioManager][setUseEarpiece] use = " + use + " ,handset = " + this.isHandset + " ,isUseEarpiece = " + this.isUseEarpiece);

        newEarpieceState = use;

        if(this.isUseEarpiece == use && (this.isHandset == use || this.isHandset == !this.audioManager.isHeadsetConnected())) {
            VoipLog.w("[VoipAudioIO][setUseEarpiece] not need set earpiece.");
        } else {
            VoipLog.d("[VoipAudioIO][setUseEarpiece] start currentIoType ="+currentIoType);

           // if(currentIoType == AUDIO_IO_TYPE.VOIP) {
           //we should not use this logic now,it will cause other problems.
              if(false){
                if(newEarpieceState == isUseEarpiece) {
                    ioUnlock();
                    return currentIoType;
                }
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        if (newEarpieceState == isUseEarpiece)
                            return;
                        setAudioRouteProcessSync(use, audioManager.isBluetoothConnected());
                    }
                }).start();
                ret = currentIoType;
            } else if(this.setAudioRouteProcess(use, this.audioManager.isBluetoothConnected())){
                ret = currentIoType;
            }
            VoipLog.d("[VoipAudioIO][setUseEarpiece] finished");
        }
        ioUnlock();
        return ret;
    }

    private void setAudioRouteProcessSync(boolean useEarpiece, boolean useBluetooth) {
       // synchronized (this) {
            ioLock();
            VoipLog.d("[VoipAudioIO][setAudioRouteProcessSync] newEarpieceState="+newEarpieceState+",isUseEarpiece=" + isUseEarpiece+",currentIoType="+currentIoType);
            if(newEarpieceState == isUseEarpiece || currentIoType != AUDIO_IO_TYPE.VOIP){
                ioUnlock();
                return;
            }
            setAudioRouteProcess(useEarpiece, useBluetooth);
            ioUnlock();
        //}
    }

    /**
     *
     * @param on
     */
    public void setBluetooth(final boolean on) {
        ioLock();
        if(this.isBluetooth == on) {
            VoipLog.w("[VoipAudioIO][setBluetooth] not need set bluetooth.");
        } else {
            VoipLog.d("[VoipAudioIO][setBluetooth] start");
            if(!this.isBluetooth && this.isPlaying) {
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1000);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        VoipLog.d("[VoipAudioIO] setBluetooth setAudioRouteProcess begin after 1000ms");

                        setAudioRouteProcess(audioManager.isHeadsetConnected(), on);

                    }
                }).start();

            } else
                this.setAudioRouteProcess(this.audioManager.isHeadsetConnected(), on);
            VoipLog.d("[VoipAudioIO][setBluetooth] finished");
        }
        ioUnlock();
    }

    public void pause() {
        ioLock();
        VoipLog.d("[VoipAudioIO][pause] start");
        if(this.isPlaying || this.isRecording) {
            if(this.audioDevice != null) {
                this.audioDevice.pause(false);
            } else {
                VoipLog.w("[VoipAudioIO][pause] audioDevice is null.");
            }

        } else {
            VoipLog.w("[VoipAudioIO][pause] not playing or recording.");
        }
        VoipLog.d("[VoipAudioIO][pause] finished");
        ioUnlock();
    }

    public void resume() {
        ioLock();
        VoipLog.d("[VoipAudioIO][resume] start currentIoType =" + this.currentIoType +"isUseEarpiece=" + this.isUseEarpiece + ",speakerOn=" + this.audioManager.isSpeakerphoneON());
        if(this.isPlaying || this.isRecording) {
            if(this.audioDevice != null) {
                if(this.currentIoType == AUDIO_IO_TYPE.RINGTONE || this.currentIoType == AUDIO_IO_TYPE.PLAYMUSIC) {
                    this.audioDevice.resume(this);
                } else {
                    this.audioDevice.resume(null);

                    if(config.product.equals("Galaxy Note")) {
                        new Thread(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(500);
                                } catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                VoipLog.d("[VoipAudioIO][resume] Galaxy Note speakerOn=" + audioManager.isSpeakerphoneON());
                                //sync the ui device and the used device in mode communication
                                if (isUseEarpiece == false &&
                                        audioManager.isSpeakerphoneON() == false &&
                                        audioManager.isBluetoothConnected() == false &&
                                        currentIoType == AUDIO_IO_TYPE.VOIP) {
                                    audioManager.resetSpecialAudioDevice(false);
                                }
                            }
                        }).start();

                    }else if (isUseEarpiece == false &&
                            audioManager.isSpeakerphoneON() == false &&
                            audioManager.isBluetoothConnected() == false &&
                            currentIoType == AUDIO_IO_TYPE.VOIP) {
                        audioManager.resetSpecialAudioDevice(false);
                    }

                }
            } else {
                VoipLog.w("[VoipAudioIO][resume] audioDevice is null.");
            }

        } else {
            VoipLog.w("[VoipAudioIO][resume] not playing or recording.");
        }
        VoipLog.d("[VoipAudioIO][resume] finished");
        ioUnlock();
    }

    public void setAudioCallback(VoipAndroid.AudioCallback audioCallback) {
        ioLock();
        this.audioCallback = audioCallback;
        if (this.audioDevice != null) {
            this.audioDevice.setAudioCallback(audioCallback);
        }

        ioUnlock();
    }

    public void setClearAudioCacheCallback(ClearAudioCacheCallback callback) {
        ioLock();
        clearAudioCacheCallback = callback;

        ioUnlock();
    }



    @Override
    public void onPlayFinished() {
        VoipLog.d("[VoipAudioIO][onPlayFinished] start");
        this.stopPlaying();
        VoipLog.d("[VoipAudioIO][onPlayFinished] finished");
    }


    @Override
    public void audioFocusLossProcess() {
        ioLock();
        VoipLog.d("[VoipAudioIO][audioFocusLossProcess] start audio focus loss processing...");

        if(this.audioDevice != null) {
            this.audioDevice.pause(true);
        } else {
            VoipLog.w("[VoipAudioIO][audioFocusLossProcess] audioDevice is null ");
        }

        VoipLog.d("[VoipAudioIO][audioFocusLossProcess] start audio focus loss processing finished.");

        ioUnlock();
    }

    @Override
    public void audioFocusLossTransientProcess() {
        ioLock();
        VoipLog.d("[VoipAudioIO][audioFocusLossTransientProcess] start audio focus loss processing...(" + this.config.vendor  +")");
//        if(this.config.vendor.equals("samsung") ) {
//            //TODO Audio focus may be lost when changing mode on some device , as samsung s3.
//        } else {
            if(this.audioDevice != null) {
                this.audioDevice.pause(true);
            } else {
                VoipLog.w("[VoipAudioIO][audioFocusLossTransientProcess] audioDevice is null ");
            }
//        }
        VoipLog.d("[VoipAudioIO][audioFocusLossTransientProcess] start audio focus loss processing finished.");
        ioUnlock();
    }

    @Override
    public void audioFocusGainProcess() {
        ioLock();
        VoipLog.d("[VoipAudioIO][audioFocusGainProcess] start audio focus gain processing...");
        if (this.currentIoType == AUDIO_IO_TYPE.RINGTONE || this.currentIoType == AUDIO_IO_TYPE.PLAYMUSIC) {
            if(this.audioDevice != null) {
                this.audioDevice.resume(this);
            } else {
                VoipLog.w("[VoipAudioIO][audioFocusGainProcess] audioDevice is null ");
            }

        } else {
            if(this.audioDevice != null) {
                if(this.config.vendor.equals("HUAWEI") && this.audioManager.ifChangedAudioMode()) {
                    VoipLog.w("[VoipAudioIO][audioFocusGainProcess]set Audioroute after audioMode changed");
                    setAudioRouteProcess(this.isUseEarpiece,this.isBluetooth);
                } else {
                    this.audioDevice.resume(null);
                }
            } else {
                VoipLog.w("[VoipAudioIO][audioFocusGainProcess] audioDevice is null ");
            }
        }
        VoipLog.d("[VoipAudioIO][audioFocusGainProcess] start audio focus gain processing finished.");
        ioUnlock();
    }

    /**
     * param isGameMode if null use default or setted
     */
    public float getSpeakerGain(Boolean isGameMode) {

        float gain;

        if(isGameMode != null) {
            this.isGameMode = isGameMode.booleanValue();
        }

        if(this.isGameMode) {
            gain = config.audioFarendGainGame;
        } else {
            if(this.isUseEarpiece) {
                if(this.audioManager.isHeadsetConnected()) {
                    //use headset
                    gain = config.audioHeadsetGain;
                } else {
                    //use receiver
                    gain = config.audioReceiverGain;
                    if(config.product.equals("Honor3")){
                        gain = 0.5f;
                    }
                }
            } else {
                gain = config.audioFarendGain;
            }
        }
        VoipLog.d("[VoipAudioIO][getSpeakerGain] game mode = " + this.isGameMode + ", earpiece = " + this.isUseEarpiece
                +  ", earpiece connected = " + this.audioManager.isHeadsetConnected() + ", gain = " + gain);

        return gain;
    }
}
