package me.chatgame.voip;

import me.chatgame.voip.VoipAudioIO.AUDIO_IO_TYPE;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Message;
import android.os.Looper;
import android.os.MessageQueue;
import android.provider.MediaStore;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by xychen on 11/2/15.
 */
public class VoipAudioManager {

    public interface VoipAudioFocusChangeCallback {
        public void audioFocusLossProcess();
        public void audioFocusLossTransientProcess();
        public void audioFocusGainProcess();
    }

    private VoipAudioFocusChangeCallback callback;
    private AudioManager audioManager;
    private ReentrantLock lock = new ReentrantLock();

    private AtomicInteger gotFocusCount = new AtomicInteger(0);

    private int originAudioMode;
    private boolean originIsSpeakerphoneON;
    private boolean originIsBluetooth;
    private boolean isPausedinLossCanDuck = false;
    private boolean bluetoothScoOn = false;

    private static final int FOCUSCHANGE = 1;
    private static final int FADEDOWN = 2;
    private static final int FADEUP = 3;

    private AUDIO_IO_TYPE ioType;
    private int streamtype;
    private int iVolumeIndex;
    private int toMode;
//    private volatile boolean changeAudioMode = false;
    private OnAudioFocusChangeListener processListener;
//    private OnAudioFocusChangeListener nonProcessListener;
    protected static VoipConfig config;

    public VoipAudioManager(VoipAudioFocusChangeCallback callback, AudioManager audioManager) {
        this.callback = callback;
        this.audioManager = audioManager;
        this.processListener = new OnAudioFocusChangeListener();
        //this.nonProcessListener = new OnAudioFocusChangeListener(null, "nonProcessListener");
    }

    public void setAudioIOandStreamType(AUDIO_IO_TYPE ioType, int streamtype){
        this.ioType = ioType;
        this.streamtype = streamtype;
        if(this.audioManager != null) {
            this.iVolumeIndex = audioManager.getStreamVolume(this.streamtype);
            VoipLog.d("[VoipAudioManager][setAudioIOandStreamType]" + this.iVolumeIndex + ",streamtype is " + this.streamtype);
        }
    }

    private Handler mAudioManagerHandler = new Handler() {
        int volumeIndex = iVolumeIndex;
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case FADEDOWN:
                    volumeIndex -= 2;
                    if (volumeIndex > 7) {
                        mAudioManagerHandler.sendEmptyMessageDelayed(FADEDOWN, 10);
                    } else if (iVolumeIndex > 6) {
                        volumeIndex = 7;
                    } else
                        volumeIndex = iVolumeIndex;
                    VoipLog.d("[VoipAudioManager][FADEDOWN]setVolume = " + volumeIndex);
                    audioManager.setStreamVolume(streamtype, volumeIndex, 0);
                    break;
                case FADEUP:
                    volumeIndex += 2;
                    if(volumeIndex < iVolumeIndex) {
                        mAudioManagerHandler.sendEmptyMessageDelayed(FADEUP,10);
                    } else {
                        volumeIndex = iVolumeIndex;
                    }
                    VoipLog.d("[VoipAudioManager][FADEUP]setVolume = " + volumeIndex);
                    audioManager.setStreamVolume(streamtype,volumeIndex,0);
                    break;
                case FOCUSCHANGE:
                    switch (msg.arg1) {
                        case AudioManager.AUDIOFOCUS_LOSS:
                            VoipLog.d("[VoipAudioManager][FocusChange]AUDIOFOCUS_LOSS");
                            mAudioManagerHandler.removeMessages(FADEUP);
                            //if(callback != null) {
                            //    callback.audioFocusLossProcess();
                            //}
                            isPausedinLossCanDuck = false;
                            break;
                        case AudioManager.AUDIOFOCUS_LOSS_TRANSIENT:
                            VoipLog.d("[VoipAudioManager][FocusChange]AUDIOFOCUS_LOSS_TRANSIENT");
                            mAudioManagerHandler.removeMessages(FADEUP);
                            isPausedinLossCanDuck = false;
                            break;
                        case AudioManager.AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK:
                            VoipLog.d("[VoipAudioManager][FocusChange]AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK");
                            iVolumeIndex = audioManager.getStreamVolume(streamtype);
                            mAudioManagerHandler.removeMessages(FADEUP);
                            mAudioManagerHandler.sendEmptyMessage(FADEDOWN);
                            isPausedinLossCanDuck = true;
                            break;
                        case AudioManager.AUDIOFOCUS_GAIN:
                        case AudioManager.AUDIOFOCUS_GAIN_TRANSIENT:
                            VoipLog.d("[VoipAudioManager][FocusChange]AUDIOFOCUS_GAIN");
                            if(isPausedinLossCanDuck) {
                                VoipLog.d("[VoipAudioManager][FocusChange]restore volume");
                                mAudioManagerHandler.removeMessages(FADEDOWN);
                                mAudioManagerHandler.sendEmptyMessage(FADEUP);
                                isPausedinLossCanDuck = false;
                            } else if(callback != null) {
                                VoipLog.d("[VoipAudioManager][FocusChange]Don't need restore volume");
                                callback.audioFocusGainProcess();
                            }
                            break;
                        default:
                            isPausedinLossCanDuck = false;
                            break;
                    }
                    break;
                default:
                    break;
            }
        }
    };

    class OnAudioFocusChangeListener implements AudioManager.OnAudioFocusChangeListener {
        @Override
        public void onAudioFocusChange(int focusChange) {
            mAudioManagerHandler.obtainMessage(FOCUSCHANGE, focusChange, 0).sendToTarget();
        }
    }

    public boolean ifneedrequestAudioFocus(AUDIO_IO_TYPE ioType){
        if(ioType == AUDIO_IO_TYPE.MESSAGERECV)
            return false;
        else
            return true;
    }

    private boolean hasSpecialMusicProcess(Context context){
        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningAppProcessInfo> run = am.getRunningAppProcesses();
        PackageManager pm =context.getPackageManager();
        boolean bIsSpecailMusic = false;
        try {
            for(ActivityManager.RunningAppProcessInfo ra : run){
                if(ra.processName.indexOf("kugou") > 0 ||
                        ra.processName.indexOf("duomi") > 0 ||
                        ra.processName.indexOf("ttpod") > 0) {
                    bIsSpecailMusic = true;
                    VoipLog.d("jinwei has kugou or duomi or ttpod");
                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return bIsSpecailMusic;
    }


    public boolean requestAudioFocus(AUDIO_IO_TYPE ioType, Context context) {
        lock.lock();
       // if(gotFocusCount.get() == 0) {
            //int requestType = ioType == AUDIO_IO_TYPE.VOIP? AudioManager.AUDIOFOCUS_GAIN : AudioManager.AUDIOFOCUS_GAIN_TRANSIENT;
            int requestType = AudioManager.AUDIOFOCUS_GAIN_TRANSIENT;

           //cancel the code, because most of the music app use the AudioManager.AUDIOFOCUS_GAIN_TRANSIENT.
           /* if(ioType == AUDIO_IO_TYPE.VOIP && !hasSpecialMusicProcess(context)) {
                requestType = AudioManager.AUDIOFOCUS_GAIN;
            }*/
            VoipLog.d("[VoipAudioManager][requestAudioFocus]requested : " + requestType + ", iotype:" + ioType);
            if(this.audioManager.requestAudioFocus(this.processListener, AudioManager.STREAM_MUSIC, requestType) == AudioManager.AUDIOFOCUS_REQUEST_GRANTED) {
                VoipLog.d("[VoipAudioManager][requestAudioFocus] got audio focus");
            } else {
                VoipLog.d("[VoipAudioManager][requestAudioFocus] failed.");
                lock.unlock();
                return false;
            }
        //}

        int count = gotFocusCount.incrementAndGet();
        VoipLog.d("[VoipAudioManager][requestAudioFocus] [ " + Thread.currentThread().getId() + "] count = " + count);
        lock.unlock();
        return true;
    }

    public boolean abandonAudioFocus() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    Thread.sleep(2000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                lock.lock();
                if(isGotFocus())
                    gotFocusCount.decrementAndGet();
                VoipLog.d("[VoipAudioManager][abandonAudioFocus] [ " + Thread.currentThread().getId() + "] count = " + gotFocusCount.get());
                if (gotFocusCount.get() == 0) {
//            this.audioManager.abandonAudioFocus(this.processListener);
                    if (audioManager.abandonAudioFocus(processListener) == AudioManager.AUDIOFOCUS_REQUEST_GRANTED) {
                        VoipLog.d("[VoipAudioManager][aboundAudioFocus] abandon audio focus.");
                    } else {
                        VoipLog.d("[VoipAudioManager][aboundAudioFocus] failed.");
                        lock.unlock();
                    }
                }
                lock.unlock();
            }
        }).start();


        return true;
    }

    public boolean isGotFocus() {
        return gotFocusCount.get() > 0;
    }

    public boolean isHeadsetConnected() {
        return this.audioManager.isWiredHeadsetOn();
    }

    public boolean isBluetoothConnected() {
        return this.audioManager.isBluetoothA2dpOn();
    }

    public int getAudioMode() {
        return this.audioManager.getMode();
    }

    public boolean isSpeakerphoneON() {
        return this.audioManager.isSpeakerphoneOn();
    }

    public void setSpeakerphoneON(final boolean on) {
        VoipLog.d("voipaudiomanager setSpeakerphoneON ON =" + on+",isSpeakerphoneON() = " +isSpeakerphoneON());
        if(isSpeakerphoneON() != on) {
            if(this.config.product.equals("MI 5") && on == true &&
                    audioManager.getMode() == audioManager.MODE_IN_COMMUNICATION) {
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            Thread.sleep(200);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        audioManager.setSpeakerphoneOn(on);
                    }
                }).start();
            } else
                this.audioManager.setSpeakerphoneOn(on);
        }
    }

    public boolean isBluetoothScoON() {
        return this.audioManager.isBluetoothScoOn();
    }

    public void storeAudioModeAndRoute() {
        this.originAudioMode = this.audioManager.getMode();
        this.originIsSpeakerphoneON = this.audioManager.isSpeakerphoneOn();
        this.originIsBluetooth = this.audioManager.isBluetoothScoOn();


        VoipLog.d("[VoipAudioManager][storeAudioModeAndRoute] store audio setting mode = " + this.originAudioMode
                + ", speakerphone = " + this.originIsSpeakerphoneON
                + ", bluetooth = " + this.originIsBluetooth);

    }

    public void restoreAudioModeAndRoute() {
        if(this.audioManager.getMode() != this.originAudioMode)
            this.audioManager.setMode(this.originAudioMode);

        this.restoreAudioRoute();


        VoipLog.d("[VoipAudioManager][storeAudioModeAndRoute] restore audio setting mode = " + this.audioManager.getMode()
                + ", speakerphone = " + this.audioManager.isSpeakerphoneOn()
                + ", bluetooth = " + this.audioManager.isBluetoothScoOn());

    }

    public boolean ifChangedAudioMode() {
        VoipLog.w("[VoipAudioManager][ifChangedAudioMode]tomode = " + this.toMode + ",OriAudioMode = " + this.getAudioMode());
        return this.toMode != this.getAudioMode();
    }
    public void setAudioModeAndRoute(AUDIO_IO_TYPE ioType, VoipConfig config, boolean isEarpiece, boolean isBluetooth) {
        // 0: AudioManager.MODE_NORMAL
        // 1: AudioManager.MODE_RINGTONE
        // 2: AudioManager.MODE_IN_CALL
        // 3: AudioManager.MODE_IN_COMMUNICATION
        VoipLog.d("[VoipAudioManager][setAudioModeAndRoute] try set: audio mode = " + config.audioMode +
                ", earpiece = " + isEarpiece + ", bluetooth = " + isBluetooth);

        //int toMode;

        if(isBluetooth) {
            if (ioType == AUDIO_IO_TYPE.VOIP || (isEarpiece == true && !this.isHeadsetConnected())) {
                this.toMode = AudioManager.MODE_IN_COMMUNICATION;
            } else {
                this.toMode = AudioManager.MODE_NORMAL;
            }

        } else if (isEarpiece && !isHeadsetConnected()) {
            this.toMode = AudioManager.MODE_IN_COMMUNICATION;
        } else {
            if (ioType == AUDIO_IO_TYPE.AUDIO_MESSAGE
                    || ioType == AUDIO_IO_TYPE.VIDEO_MESSAGE
                    || ioType == AUDIO_IO_TYPE.MESSAGERECV
                    || ioType == AUDIO_IO_TYPE.PLAYMUSIC
                    || ioType == AUDIO_IO_TYPE.RINGTONE) {
                this.toMode = AudioManager.MODE_NORMAL;
            } else {
                this.toMode = config.audioMode;
            }
        }

        if(this.toMode != this.getAudioMode() &&
                this.getAudioMode() != AudioManager.MODE_IN_CALL) {
                this.audioManager.setMode(toMode);
        }

        this.setAudioRoute(isEarpiece, isBluetooth);

        VoipLog.d("[VoipAudioManager][setAudioModeAndRoute] set result: audio mode = " + this.audioManager.getMode() +
                ", speakerphone = " + this.audioManager.isSpeakerphoneOn() + ", bluetooth sco = " + this.audioManager.isBluetoothScoOn());
    }

    /**
     * resetSpecailAudioMode
     *
     * here mode must be simular with setAudioModeAndRoute
     *
     * @param isHandset
     *            current device is handset or not.
     * isHandset == true  : setAudioMode to MODE_IN_COMMUNICATION
     * isHandset == false : setAudioMode to MODE_IN_NORMAL
     */
    public void resetSpecailAudioMode (boolean isHandset) {
        if(isHandset == true) {
            if(this.getAudioMode() != AudioManager.MODE_IN_COMMUNICATION &&
                    this.getAudioMode() != AudioManager.MODE_IN_CALL) {
                VoipLog.d("[VoipAudioManager][resetSpecialAudioMode]setAudioMode result COMMUNICATION!");
                this.audioManager.setMode(AudioManager.MODE_IN_COMMUNICATION);
            }
        } else {
            if(this.getAudioMode() != AudioManager.MODE_NORMAL &&
                    this.getAudioMode() != AudioManager.MODE_IN_CALL) {
                VoipLog.d("[VoipAudioManager][resetSpecialAudioMode]setAudioMode result NORMAL!");
                this.audioManager.setMode(AudioManager.MODE_NORMAL);
            }
        }
    }

    public void resetSpecialAudioDevice(final boolean useEarpiece) {
        if (this.audioManager != null){
            VoipLog.d("[VoipAudioManager][setPhoneSpeakeron]set result speaker is " + !useEarpiece);
            new Thread(new Runnable() {
                @Override
                public void run() {
                    try {
                        Thread.sleep(200);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    setSpeakerphoneON(!useEarpiece);
            }
            }).start();
        }
    }

    public void setAudioRoute(boolean isEarpiece, boolean isBluetooth) {
        ////TODO close now, SCO is use bluetooth mic
        VoipLog.d("setAudioRoute isBluetooth="+isBluetooth+",isEarpiece="+isEarpiece+",isheadset="+isHeadsetConnected());
        if(isBluetooth) {
            setSpeakerphoneON(false);
            if(isEarpiece) {
                setScoRecordRoute(false);
            } else if(this.audioManager.getMode() == AudioManager.MODE_IN_COMMUNICATION){
                VoipLog.d("setBluetoothScoOn true begin!");
                setScoRecordRoute(true);
            }
        } else {
            setSpeakerphoneON(!isEarpiece);
            setScoRecordRoute(false);
        }
    }

    public void restoreAudioRoute() {
        setSpeakerphoneON(this.originIsSpeakerphoneON);
        if (isBluetoothScoON()) {
            this.audioManager.stopBluetoothSco();
        }
        if(originIsBluetooth != isBluetoothScoON())
            this.audioManager.setBluetoothScoOn(this.originIsBluetooth);
    }

    public void setScoRecordRoute(boolean on) {
        VoipLog.d("setScoRecordRoute on =" + on +",isBluetoothScoOn = " + this.audioManager.isBluetoothScoOn() + ",ScoOn = " +this.bluetoothScoOn);

        if (on) {
            if (!this.bluetoothScoOn) {
                this.audioManager.setBluetoothScoOn(true);
                this.audioManager.startBluetoothSco();
                this.bluetoothScoOn = true;

            }
        } else if (this.bluetoothScoOn) {
            new Thread(new Runnable() {
                @Override
                public void run() {
                    try {
                        Thread.sleep(200);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    audioManager.stopBluetoothSco();
                    audioManager.setBluetoothScoOn(false);
                    bluetoothScoOn = false;
                }
            }).start();
        }
    }

}
