package me.chatgame.voip;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import android.media.AudioManager;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Base64;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by xychen on 6/26/15.
 */
public class VoipConfig {

	public static final int DEVICE_OPENSL = 0;
	public static final int DEVICE_JAVA = 1;

	public String product = "default";
	public String vendor = Build.MANUFACTURER;
	public String device = Build.DEVICE;
	public String model = Build.MODEL;

	// Product /Mode / openSL:0 JAVA:1 / useWebRTC / Recording preset / Stream
	// type / AecOut gain / Farend gain / AecOut (GAME) / Farend gain (GAME)
	// default /3 / 0 / 1 / 4 / 0 / 1.0 / 1.0 / 1.0 / 1.0
	// default-JAVA /3 / 1 / 1 / 7 / 0 / 1.0 / 1.0 / 1.0 / 1.0
	public int audioMode = AudioManager.MODE_IN_COMMUNICATION;
	public int audioModeSpeakerphone = AudioManager.MODE_IN_COMMUNICATION;
	public int audioDevice = 1;
	public boolean audioUseWebRTC = true;
	public int audioRecordingPreset = MediaRecorder.AudioSource.VOICE_COMMUNICATION;
	public int audioStreamType = AudioManager.STREAM_VOICE_CALL;
	public float audioAecOutGain = 1.0f;
	public float audioFarendGain = 1.0f;
	public float audioAecOutGainGame = 1.0f;
	public float audioFarendGainGame = 1.0f;
	public int audioAecAggressiveLevel = 0;
	public int audioBubbleSpecialMode = 0;
        public boolean audioSetPhonespkInSpecialMode = false;

	public float audioHeadsetGain = 1.0f;
	public float audioReceiverGain = 2.0f;
	//public int recordSampleRate = 16000; // keep config for old version
	public int hardwareSampleRate = 48000; //hardware sample rate
	public int channelSampleRate = 48000; //voip audio process channel sample rate

	//Product           /cpu level /video width / video height  / video angle (front 270) /video angel (back 90)
	// default / 2 / 640 / 480 / 3 / 1
	public int cpuLevel = 2;
	public int videoWidth = 640;
	public int videoHeight = 480;
	public int videoAngle = 3;
	public int videoAngleBack = 1;

	// Product /color algorithm/color strength/filter algorithm/filter
	// strength/reserved
	// default / 0 / 1.0 / 0 / 1.0 / -1
	public int colorAlgorithm = 0;
	public float colorStreangth = 1.0f;
	public int colorFilterAlgorithm = 0;
	public float colorFilterStrength = 1.0f;
	public int colorReserved = -1;

	private static final String algorithmStr = "AES/CBC/NoPadding";
	private static final String keyStr = "1620597d250c0bab";
	private static final String iv = "5e707cd881f06b8a";

	public static VoipConfig loadLoaclJsonConfig(JSONObject audioCfg) {

		/**
		 * config sample
		 *
		{
			"product":"HongMi1s",
			"vendor":"Xiaomi",
			"device":"armani",
			"model":"HM1S",
			"audioMode":3,
			"audioDevice":1,
			"audioUseWebRTC":false,
			"audioRecordingPreset":7,
			"audioStreamType":0,
			"audioAecOutGain":1.0,
			"audioFarendGain":1.0,
			"audioAecOutGainGame":1.0,
			"audioFarendGainGame":1.0,
			"audioAecAggressiveLevel":0,
			"audioBubbleSpecialMode":0,
			"cpuLevel":2,
			"videoWidth":640,
			"videoHeight":480,
			"videoAngle":3,
			"videoAngleBack":1,
			"colorAlgorithm":0,
			"colorStreangth":1.0,
			"colorFilterAlgorithm":0,
			"colorFilterStrength":1.0,
			"colorReserved":-1,
			"record_samplerate":16000
		}
		 */

		VoipConfig cfg = new VoipConfig(null);

		cfg.product = audioCfg.getString("product");

		cfg.audioMode = audioCfg.getInteger("audioMode");
		cfg.audioDevice = audioCfg.getInteger("audioDevice");
		cfg.audioUseWebRTC = audioCfg.getBoolean("audioUseWebRTC");
		cfg.audioRecordingPreset = audioCfg.getInteger("audioRecordingPreset");
		cfg.audioStreamType = audioCfg.getInteger("audioStreamType");
		cfg.audioAecOutGain = audioCfg.getFloat("audioAecOutGain");
		cfg.audioFarendGain = audioCfg.getFloat("audioFarendGain");
		cfg.audioAecOutGainGame = audioCfg.getFloat("audioAecOutGainGame");
		cfg.audioFarendGainGame = audioCfg.getFloat("audioFarendGainGame");
		cfg.audioAecAggressiveLevel = audioCfg.getInteger("audioAecAggressiveLevel");
		cfg.audioBubbleSpecialMode = audioCfg.getInteger("audioBubbleSpecialMode");

		cfg.cpuLevel = audioCfg.getInteger("cpuLevel");
		cfg.videoWidth = audioCfg.getInteger("videoWidth");
		cfg.videoHeight = audioCfg.getInteger("videoHeight");
		cfg.videoAngle = audioCfg.getInteger("videoAngle");
		cfg.videoAngleBack = audioCfg.getInteger("videoAngleBack");

		cfg.colorAlgorithm = audioCfg.getInteger("colorAlgorithm");
		cfg.colorStreangth = audioCfg.getFloat("colorStreangth");
		cfg.colorFilterAlgorithm = audioCfg.getInteger("colorFilterAlgorithm");
		cfg.colorFilterStrength = audioCfg.getFloat("colorFilterStrength");
		cfg.colorReserved = audioCfg.getInteger("colorReserved");
		//cfg.recordSampleRate = audioCfg.getInteger("record_samplerate");
		cfg.hardwareSampleRate = audioCfg.getInteger("hardware_samplerate");
		cfg.channelSampleRate = audioCfg.getInteger("channel_samplerate");

		if (cfg.product.equals("MI 3 (TD)")) {
			cfg.audioSetPhonespkInSpecialMode = true;
		}

		VoipLog.d("[VoipConfig][VoipConfig] update:" + cfg.toString());

		return cfg;
	}


	public int getFrameSize(int sampleRate){
		int frameSize;
		switch (sampleRate){
			case 48000:
				frameSize = 960;
				break;
			case 44100:
				frameSize = 882;
				break;
			case 32000:
				frameSize = 640;
				break;
			case 16000:
				frameSize = 320;
				break;
			case 8000:
				frameSize = 160;
				break;
			default:
				frameSize = 320;

		}
		return frameSize;
	}


	public VoipConfig(JSONObject jsonConfig) {
		if (null != jsonConfig) {
			try {
				this.product = jsonConfig.getString("product");
//				this.vendor = jsonConfig.getString("vendor");
//				this.device = jsonConfig.getString("device");
//				this.model = jsonConfig.getString("model");
				//this.cpuLevel = jsonConfig.getInteger("cpu_level");
				byte[] decoded = Base64.decode(jsonConfig.getString("config"),
						Base64.DEFAULT);

				Cipher cipher = Cipher.getInstance(algorithmStr);

				SecretKeySpec keyspec = new SecretKeySpec(keyStr.getBytes(),
						"AES");
				IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes());
				cipher.init(Cipher.DECRYPT_MODE, keyspec, ivspec);
				byte[] originBytes = cipher.doFinal(decoded);
				JSONObject jsonCfg = JSON.parseObject(new String(originBytes)
						.trim());

				JSONObject audioCfg = jsonCfg.getJSONObject("audio_cfg");
				this.audioMode = audioCfg.getInteger("mode");
				this.audioDevice = audioCfg.getInteger("device");
				this.audioUseWebRTC = audioCfg.getInteger("use_webrtc") == 1 ? true
						: false;
				this.audioRecordingPreset = audioCfg
						.getInteger("record_preset");
				this.audioStreamType = audioCfg.getInteger("stream_type");
				this.audioAecOutGain = audioCfg.getFloat("aecout_gain");
				this.audioFarendGain = audioCfg.getFloat("farend_gain");
				this.audioAecOutGainGame = audioCfg.getFloat("aecout_gain_game");
				this.audioFarendGainGame = audioCfg.getFloat("farend_gain_game");
				this.audioAecAggressiveLevel = audioCfg.getInteger("aggressive_level");
				//this.recordSampleRate = audioCfg.getInteger("record_samplerate");
				this.hardwareSampleRate = audioCfg.getInteger("hardware_samplerate");
				this.channelSampleRate = audioCfg.getInteger("channel_samplerate");

				if (product.equalsIgnoreCase("MI 4")) {
					this.audioBubbleSpecialMode = 1;
				}

				if (product.equals("MI 3 (TD)")) {
					this.audioSetPhonespkInSpecialMode = true;
				}
				JSONObject videoCfg = jsonCfg.getJSONObject("video_cfg");
				this.cpuLevel = videoCfg.getInteger("cpu_level");
				this.videoWidth = videoCfg.getInteger("video_width");
				this.videoHeight = videoCfg.getInteger("video_height");
				this.videoAngle = videoCfg.getInteger("video_angle");
				this.videoAngleBack = videoCfg.getInteger("video_angle_back");

				JSONObject colorCfg = jsonCfg.getJSONObject("color_cfg");
				this.colorAlgorithm = colorCfg.getInteger("color_algorithm");
				this.colorStreangth = colorCfg.getFloat("color_strength");
				this.colorFilterAlgorithm = colorCfg
						.getInteger("filter_algorithm");
				this.colorFilterStrength = colorCfg.getFloat("filter_strength");
				this.colorReserved = colorCfg.getInteger("reserved");

				VoipLog.d("[VoipConfig][VoipConfig] update:" + this.toString());

			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			VoipLog.e("[VoipConfig][VoipConfig] jsonConfig is null.");
		}
	}

	@Override
	public String toString() {
		return "[VoipConfig] {" + "product='" + product + '\'' + ", vendor='"
				+ vendor + '\'' + ", device='" + device + '\'' + ", model='"
				+ model + '\'' + ", audioMode=" + audioMode + ", audioDevice="
				+ audioDevice + ", audioUseWebRTC=" + audioUseWebRTC
				+ ", audioRecordingPreset=" + audioRecordingPreset
				+ ", audioStreamType=" + audioStreamType + ", audioAecOutGain="
				+ audioAecOutGain + ", audioFarendGain=" + audioFarendGain
				+ ", audioAecOutGainGame=" + audioAecOutGainGame
				+ ", audioFarendGainGame=" + audioFarendGainGame
				+ ", audioAecAggressiveLevel=" + audioAecAggressiveLevel
				+ ", audioBubbleSpecialMode=" + audioBubbleSpecialMode
				+ ", cpuLevel=" + cpuLevel + ", videoWidth=" + videoWidth
				+ ", videoHeight=" + videoHeight + ", videoAngle=" + videoAngle + ", videoAngleBack=" + videoAngleBack
				+ ", colorAlgorithm=" + colorAlgorithm + ", colorStreangth="
				+ colorStreangth + ", colorFilterAlgorithm="
				+ colorFilterAlgorithm + ", colorFilterStrength="
				+ colorFilterStrength + ", colorReserved=" + colorReserved
				+ '}';
	}



//	public static void main(String[] args) {
//		JSONObject jsonConfig = new JSONObject();
//		jsonConfig.put("product", "default");
//		jsonConfig.put("vendor", "default");
//		jsonConfig.put("device", "default");
//		jsonConfig.put("model", "default");
//		jsonConfig.put("cpu_level", "1");
//		jsonConfig.put("config","");
//				VoipConfig voipConfig = new VoipConfig(jsonConfig);
//		System.out.println(voipConfig);
//	}

}
