package me.chatgame.voip;

/**
 * Voip image class presents a video frame to render.
 */
public class VoipImage {
	/**
	 * Video rotation angle 0 degree
	 */
	public static final int VIDEO_ROTATION_0 = 0;

	/**
	 * Video rotation angle 90 degree
	 */
	public static final int VIDEO_ROTATION_90 = 1;

	/**
	 * Video rotation angle 180 degree
	 */
	public static final int VIDEO_ROTATION_180 = 2;

	/**
	 * Video rotation angle 270 degree
	 */
	public static final int VIDEO_ROTATION_270 = 3;

	/**
	 * Raw yuv420 data of image
	 */
	public byte[] data;

	/**
	 * Image width
	 */
	public int width;

	/**
	 * Image height
	 */
	public int height;

	/**
	 * If the image is in darkness
	 */
	public boolean isDarkness;

	/**
	 * If the image is captured from front camera
	 */
	public boolean isFrontCamera;

	/**
	 * The image rotation angle when rendering
	 */
	public int rotation;

	/**
	 * Face lifting, current range: -0.05~0.15
	 */
	public float facelift;

	/**
	 * User ID of this image
	 */
	public int userId;
}
