package me.chatgame.voip;

/**
 * Voip statistics class presents the voip call status.
 */
public class VoipStatistics {
	/**
	 * Audio sending bitrate in 1 sec
	 */
	public int audioTxBitrate;

	/**
	 * Audio sending average encoding time in 1 sec
	 */
	public int audioTxAverageEncodingTime;

	/**
	 * Audio sending max encoding time in the call
	 */
	public int audioTxMaxEncodingTime;

	/**
	 * Audio sending average time from captured to sent to network in 1 sec
	 */
	public int audioTxAveragePipelineTime;

	/**
	 * Audio sending max time from captured to sent to network in the call
	 */
	public int audioTxMaxPipelineTime;

	/**
	 * Audio receiving average decoding time in 1 sec
	 */
	public int audioRxAverageDecodingTime;

	/**
	 * Audio receiving max decoding time in the call
	 */
	public int audioRxMaxDecodingTime;

	/**
	 * Audio receiving average time from received to played in 1 sec
	 */
	public int audioRxAveragePipelineTime;

	/**
	 * Audio receiving max time from received to played in the call
	 */
	public int audioRxMaxPipelineTime;

	/**
	 * Audio receiving lost packets count in 1 sec
	 */
	public int audioRxLostPackets;

	/**
	 * Audio receiving packets loss ratio in 1 sec
	 */
	public int audioRxPacketLoss;

	/**
	 * Video sending width
	 */
	public int videoTxWidth;

	/**
	 * Video sending height
	 */
	public int videoTxHeight;

	/**
	 * Video sending fps in 1 sec
	 */
	public int videoTxFps;

	/**
	 * Video sending bitrate from encoder in 1 sec
	 */
	public int videoTxBitrate;

	/**
	 * Total send IDR frames count
	 */
	public int videoTxTotalIDR;

	/**
	 * Average video encoding time in 1 sec
	 */
	public int videoTxAverageEncodingTime;

	/**
	 * Max video encoding time in the call
	 */
	public int videoTxMaxEncodingTime;

	/**
	 * Average time of video frame from captured to last packets being sent in 1
	 * sec
	 */
	public int videoTxAveragePipelineTime;

	/**
	 * Max time of video frame from captured to last packets being sent in the
	 * call
	 */
	public int videoTxMaxPipelineTime;

	/**
	 * Video sent bitrate (including retransmission and frame drops) to network
	 * in 1 sec
	 */
	public int videoTxSentBitrate;

	/**
	 * Video sent target bitrate
	 */
	public int videoTxTargetBitrate;

	/**
	 * Video receiving width
	 */
	public int videoRxWidth;

	/**
	 * Video receiving height
	 */
	public int videoRxHeight;

	/**
	 * Video receiving fps in 1 sec
	 */
	public int videoRxFps;

	/**
	 * Video receiving bitrate
	 */
	public int videoRxBitrate;

	/**
	 * Total IDR frames received in the call
	 */
	public int videoTotalIDR;

	/**
	 * Average video decoding time in 1 sec
	 */
	public int videoRxAverageDecodingTime;

	/**
	 * Max video decoding time in the call
	 */
	public int videoRxMaxDecodingTime;

	/**
	 * Average time of a video frame from the first packet received to rendered
	 * in 1 sec
	 */
	public int videoRxAveragePipelineTime;

	/**
	 * Max time of a video frame from the first packet received to rendered in
	 * the call
	 */
	public int videoRxMaxPipelineTime;

	/**
	 * Lost video packets count in 1 sec
	 */
	public int videoRxLostPackets;

	/**
	 * Video packet loss ratio in 1 sec
	 */
	public int videoRxPacketLoss;

	/**
	 * Lost video undiscardable packets count in 1 sec
	 */
	public int videoRxLostUndiscardPackets;

	/**
	 * Video undiscardable packet loss ratio in 1 sec
	 */
	public int videoRxUndiscardPacketLoss;

	/**
	 * Current round-trip time
	 */
	public int rtt;
}
