/*
 * Decompiled with CFR 0.152.
 */
package me.clutchy.dependenciesgen.gradle;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import me.clutchy.dependenciesgen.gradle.DependenciesGen;
import me.clutchy.dependenciesgen.shared.Dependency;
import me.clutchy.dependenciesgen.shared.downloader.DependencyDownloader;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.UrlArtifactRepository;

public class DependenciesGenPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getTasks().register("gen-dependencies", task -> this.createDependenciesJson(project, (DependenciesGen)project.getExtensions().getByType(DependenciesGen.class)));
        project.getExtensions().create("DependenciesGen", DependenciesGen.class, new Object[]{project});
    }

    private void createDependenciesJson(Project project, DependenciesGen extension) {
        Path metaResources = project.getBuildDir().toPath().resolve("resources").resolve("main").resolve("META-INF");
        metaResources.toFile().mkdirs();
        try (BufferedWriter writer = Files.newBufferedWriter(metaResources.resolve("dependencies.json"), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(this.getAllDependencies(project, extension).toString());
        }
        catch (IOException e) {
            System.out.println("Error writing dependencies.json");
        }
    }

    private List<Dependency> getAllDependencies(Project project, DependenciesGen extension) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(DependencyDownloader.REQUIRED_DEPENDENCIES);
        project.getConfigurations().getByName("api").getResolvedConfiguration().getFirstLevelModuleDependencies().forEach(depend -> dependencies.addAll(this.getDependenciesFromParent(project, (ResolvedDependency)depend, extension)));
        return dependencies;
    }

    private List<Dependency> getDependenciesFromParent(Project project, ResolvedDependency depend, DependenciesGen extension) {
        String name;
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        String group = depend.getModuleGroup();
        if (extension.ignored.contains(group + ":" + (name = depend.getModuleName()))) {
            return new ArrayList<Dependency>();
        }
        String version = depend.getModuleVersion();
        String repo = this.getRepo(project, group, name, version);
        ArrayList<Dependency> children = new ArrayList<Dependency>();
        if (depend.getChildren().size() != 0) {
            depend.getChildren().forEach(childDepend -> {
                if (childDepend.getParents().contains(depend) && childDepend.getConfiguration().equals("compile")) {
                    children.addAll(this.getDependenciesFromParent(project, (ResolvedDependency)childDepend, extension));
                }
            });
        }
        dependencies.add(new Dependency(group, name, version, repo, children));
        return dependencies;
    }

    private String getRepo(Project project, String group, String name, String version) {
        for (ArtifactRepository artifactRepo : project.getRepositories()) {
            URL dependencyURL;
            UrlArtifactRepository repository;
            if (!(artifactRepo instanceof UrlArtifactRepository) || !(repository = (UrlArtifactRepository)artifactRepo).getUrl().toString().matches("(?!file\\b)\\w+?:\\/\\/.*") || !this.checkIfURLExists(dependencyURL = this.getDependencyURL(repository.getUrl().toString(), group, name, version))) continue;
            return repository.getUrl().toString();
        }
        return null;
    }

    private URL getDependencyURL(String url, String group, String name, String version) {
        if (url == null || ((String)url).trim().isEmpty()) {
            return null;
        }
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        try {
            return new URL((String)url + this.getPath(group, name, version) + this.getFileName(name, version));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private String getPath(String group, String name, String version) {
        return group.replaceAll("\\.", "/") + "/" + name + "/" + version + "/";
    }

    private String getFileName(String name, String version) {
        return name + "-" + version + ".jar";
    }

    private boolean checkIfURLExists(URL url) {
        if (url == null) {
            return false;
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            connection.disconnect();
            return 200 <= responseCode && responseCode <= 399;
        }
        catch (Exception e) {
            return false;
        }
    }
}

