/*
 * Decompiled with CFR 0.152.
 */
package me.clutchy.dependenciesgen.shared;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import me.clutchy.dependenciesgen.shared.Dependency;

public class JsonDependency
extends Dependency {
    public JsonDependency(JsonObject json) {
        super(json.get("group").getAsString(), json.get("name").getAsString(), json.get("version").getAsString(), json.get("repo").getAsString(), new ArrayList<Dependency>());
        this.dependencies = this.getDependencies(json);
    }

    public List<Dependency> getDependencies(JsonObject json) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        try {
            JsonElement value = json.get("dependencies");
            if (value instanceof JsonArray) {
                ((JsonArray)value).forEach(jsonValue -> {
                    if (jsonValue instanceof JsonObject) {
                        return;
                    }
                    dependencies.add(new JsonDependency((JsonObject)jsonValue));
                });
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return dependencies;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public JsonObject toJSON() {
        JsonArray array = new JsonArray();
        this.dependencies.forEach(dependency -> {
            if (dependency instanceof JsonDependency) {
                array.add((JsonElement)((JsonDependency)dependency).toJSON());
            }
        });
        JsonObject object = this.toJSONNoDepends();
        object.add("dependencies", (JsonElement)array);
        return object;
    }

    private JsonObject toJSONNoDepends() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("group", this.getGroup());
        jsonObject.addProperty("name", this.getName());
        jsonObject.addProperty("version", this.getVersion());
        if (this.getRepo() != null) {
            jsonObject.addProperty("repo", this.getRepo());
        }
        return jsonObject;
    }
}

