/*
 * Decompiled with CFR 0.152.
 */
package me.clutchy.dependenciesgen.shared.downloader;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.clutchy.dependenciesgen.shared.Dependency;
import me.clutchy.dependenciesgen.shared.JsonDependency;
import me.clutchy.dependenciesgen.shared.downloader.DownloadCallback;

public class DependencyDownloader {
    public static final List<Dependency> REQUIRED_DEPENDENCIES = List.of(new Dependency("org.apache.logging.log4j", "log4j-core", "2.17.2", "", List.of(new Dependency("org.apache.logging.log4j", "log4j-api", "2.17.2", "", new ArrayList<Dependency>()))), new Dependency("com.google.code.gson", "gson", "2.9.0", "", new ArrayList<Dependency>()));
    private static final ArrayList<String> loadedArtifacts = new ArrayList();
    private final Logger logger;

    public DependencyDownloader(Logger logger) {
        this.logger = logger;
    }

    public void downloadDefaults(DownloadCallback callback) {
        this.downloadDependencies(REQUIRED_DEPENDENCIES, callback);
    }

    public void downloadDependencies(InputStream stream, DownloadCallback callback) {
        if (stream == null) {
            return;
        }
        Gson gson = new Gson();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            JsonArray object = (JsonArray)gson.fromJson((Reader)reader, JsonArray.class);
            for (JsonElement value : object) {
                if (!(value instanceof JsonObject)) continue;
                dependencies.add(new JsonDependency((JsonObject)value));
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Error reading dependencies json", e);
            System.exit(0);
        }
        this.downloadDependencies(dependencies, callback);
    }

    public void downloadDependencies(List<Dependency> parentDependencies, DownloadCallback callback) {
        this.logger.info("Loading dependencies");
        ArrayList dependencies = new ArrayList();
        ArrayList loadedDependenciesIds = new ArrayList();
        parentDependencies.forEach(parentDependency -> dependencies.addAll(this.getDependenciesFromParent((Dependency)parentDependency)));
        Collections.sort(dependencies);
        CountDownLatch latch = new CountDownLatch(dependencies.size());
        for (Dependency dependency : dependencies) {
            if (loadedArtifacts.contains(dependency.getGroup() + ":" + dependency.getName())) {
                latch.countDown();
                continue;
            }
            loadedArtifacts.add(dependency.getGroup() + ":" + dependency.getName());
            new Thread(() -> {
                File cacheDependencyPath = new File("cache", this.getPath(dependency));
                try {
                    Files.createDirectories(cacheDependencyPath.toPath(), new FileAttribute[0]);
                    File jar = cacheDependencyPath.toPath().resolve(this.getFileName(dependency, false)).toFile();
                    if (!jar.exists()) {
                        this.downloadFile(dependency, jar, false);
                    } else {
                        this.logger.info("Checking dependency: " + dependency.getName());
                        byte[] bytes = Files.readAllBytes(jar.toPath());
                        byte[] hash = MessageDigest.getInstance("MD5").digest(bytes);
                        String md5 = this.toHexString(hash);
                        if (!md5.trim().isEmpty()) {
                            try (BufferedReader readerUrl = new BufferedReader(new InputStreamReader(this.getConnection(dependency, true), StandardCharsets.UTF_8));){
                                String urlMd5 = readerUrl.readLine();
                                if (urlMd5 != null && !urlMd5.equalsIgnoreCase(md5)) {
                                    this.downloadFile(dependency, jar, true);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    callback.callback(jar.toURI().toURL());
                    loadedDependenciesIds.add(dependency.getName());
                }
                catch (Exception e) {
                    latch.countDown();
                    this.logger.log(Level.SEVERE, "Error loading dependency: " + dependency.getName(), e);
                    loadedArtifacts.remove(dependency.getGroup() + ":" + dependency.getName());
                    System.exit(0);
                }
                finally {
                    latch.countDown();
                }
            }).start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            this.logger.severe("Error loading dependency: ");
            System.exit(0);
        }
        if (!loadedDependenciesIds.isEmpty()) {
            Collections.sort(loadedDependenciesIds);
            String loadedDependencies = ((Object)loadedDependenciesIds).toString().substring(1).replaceFirst("]", "");
            this.logger.info("Loaded dependencies: " + loadedDependencies);
        }
    }

    private String toHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(0xFF & aByte);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private URL getUrl(Dependency dependency, boolean hash) throws MalformedURLException {
        Object repo = dependency.getRepo();
        if (repo == null || ((String)repo).trim().isEmpty()) {
            repo = "https://repo.maven.apache.org/maven2/";
        }
        if (!((String)repo).endsWith("/")) {
            repo = (String)repo + "/";
        }
        return new URL((String)repo + this.getPath(dependency) + this.getFileName(dependency, hash));
    }

    private String getFileName(Dependency dependency, boolean hash) {
        return dependency.getName() + "-" + dependency.getVersion() + ".jar" + (hash ? ".md5" : "");
    }

    private String getPath(Dependency dependency) {
        return dependency.getGroup().replaceAll("\\.", "/") + "/" + dependency.getName() + "/" + dependency.getVersion() + "/";
    }

    private void downloadFile(Dependency dependency, File location, boolean reDownload) throws IOException {
        this.logger.info((reDownload ? "Red" : "D") + "ownloading dependency: " + dependency.getName());
        try (InputStream inputStream = this.getConnection(dependency, false);){
            Files.copy(inputStream, location.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private InputStream getConnection(Dependency dependency, boolean MD5) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.getUrl(dependency, MD5).openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        connection.setRequestMethod("GET");
        connection.connect();
        return connection.getInputStream();
    }

    public List<Dependency> getDependenciesFromParent(Dependency dependency) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(Collections.singletonList(dependency));
        dependency.getDependencies().forEach(childDepend -> dependencies.addAll(this.getDependenciesFromParent((Dependency)childDepend)));
        return dependencies;
    }
}

