/*
 * Decompiled with CFR 0.152.
 */
package me.cmoz.gradle.snapshot;

import java.text.SimpleDateFormat;
import lombok.NonNull;

public class SnapshotPluginExtension {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat();
    public static final String DEFAULT_FILENAME = "snapshot.properties";
    public static final String DEFAULT_DATEFORMAT = "dd.MM.yyyy '@' HH:mm:ss z";
    public static final boolean DEFAULT_VERBOSE = Boolean.FALSE;
    private String filename;
    private String dateFormat;
    private boolean verbose;

    public SnapshotPluginExtension() {
        this.setFilename(DEFAULT_FILENAME);
        this.setDateFormat(DEFAULT_DATEFORMAT);
        this.setVerbose(DEFAULT_VERBOSE);
    }

    public void setDateFormat(@NonNull String format) {
        if (format == null) {
            throw new NullPointerException("format");
        }
        SIMPLE_DATE_FORMAT.applyPattern(format);
        this.dateFormat = format;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnapshotPluginExtension)) {
            return false;
        }
        SnapshotPluginExtension other = (SnapshotPluginExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        return this.isVerbose() == other.isVerbose();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SnapshotPluginExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 0 : $filename.hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 0 : $dateFormat.hashCode());
        result = result * 59 + (this.isVerbose() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SnapshotPluginExtension(filename=" + this.getFilename() + ", dateFormat=" + this.getDateFormat() + ", verbose=" + this.isVerbose() + ")";
    }
}

