/*
 * Decompiled with CFR 0.152.
 */
package me.cmoz.gradle.snapshot;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import lombok.NonNull;
import me.cmoz.gradle.snapshot.Commit;
import me.cmoz.gradle.snapshot.SCMCommand;
import me.cmoz.gradle.snapshot.SCMUtil;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.gradle.api.Project;

class GitSCMCommand
implements SCMCommand {
    private static final String REPO_DIRNAME = ".git";
    private final File repoDir;

    public GitSCMCommand(Project project) {
        this.repoDir = SCMUtil.scanDir(project, REPO_DIRNAME);
    }

    @Override
    @Nullable
    public File getRepositoryDir() {
        return this.repoDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Commit getLatestCommit(@NonNull String dateFormat) {
        Commit commit;
        if (dateFormat == null) {
            throw new NullPointerException("dateFormat");
        }
        if (this.repoDir == null) {
            throw new IllegalStateException("'.git' folder could not be found.");
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(this.repoDir)).readEnvironment()).build();
        StoredConfig conf = repo.getConfig();
        int abbrev = 7;
        if (conf != null) {
            abbrev = conf.getInt("core", "abbrev", abbrev);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Ref HEAD = repo.getRef("HEAD");
        if (HEAD.getObjectId() == null) {
            throw new RuntimeException("Could not find any commits from HEAD ref.");
        }
        RevWalk revWalk = new RevWalk(repo);
        if (HEAD.getObjectId() == null) {
            throw new RuntimeException("Could not find any commits from HEAD ref.");
        }
        RevCommit revCommit = revWalk.parseCommit((AnyObjectId)HEAD.getObjectId());
        revWalk.markStart(revCommit);
        try {
            Date commitTime = new Date((long)revCommit.getCommitTime() * 1000L);
            PersonIdent ident = revCommit.getAuthorIdent();
            commit = Commit.builder().buildTime(sdf.format(new Date())).buildAuthorName(conf.getString("user", null, "name")).buildAuthorEmail(conf.getString("user", null, "email")).branchName(repo.getBranch()).commitId(revCommit.getName()).commitTime(sdf.format(commitTime)).commitUserName(ident.getName()).commitUserEmail(ident.getEmailAddress()).commitMessage(revCommit.getFullMessage().trim()).build();
        }
        catch (Throwable throwable) {
            revWalk.dispose();
            repo.close();
            throw throwable;
        }
        revWalk.dispose();
        repo.close();
        return commit;
    }

    public File getRepoDir() {
        return this.repoDir;
    }
}

