/*
 * Decompiled with CFR 0.152.
 */
package me.cmoz.gradle.snapshot;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;
import me.cmoz.gradle.snapshot.Commit;
import me.cmoz.gradle.snapshot.SCMCommand;
import me.cmoz.gradle.snapshot.SCMUtil;
import org.gradle.api.Project;
import org.tmatesoft.hg.core.HgChangeset;
import org.tmatesoft.hg.core.HgLogCommand;
import org.tmatesoft.hg.core.HgRepoFacade;

class HgSCMCommand
implements SCMCommand {
    private static final String REPO_DIRNAME = ".hg";
    private File repoDir;

    public HgSCMCommand(Project project) {
        this.repoDir = SCMUtil.scanDir(project, REPO_DIRNAME);
    }

    @Override
    @Nullable
    public File getRepositoryDir() {
        return this.repoDir;
    }

    @Override
    public Commit getLatestCommit(@NonNull String dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("dateFormat");
        }
        if (this.repoDir == null) {
            throw new IllegalStateException("'.hg' folder could not be found.");
        }
        HgRepoFacade repo = new HgRepoFacade();
        repo.initFrom(this.repoDir);
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        int lastRevision = repo.getRepository().getChangelog().getLastRevision();
        if (lastRevision == -1) {
            throw new RuntimeException("Could not find any changesets in Hg repository.");
        }
        HgLogCommand hgLogCommand = repo.createLogCommand();
        hgLogCommand.range(lastRevision, lastRevision);
        List changesets = hgLogCommand.execute();
        if (changesets.size() < 1) {
            throw new RuntimeException("Could not find any changesets in Hg repository.");
        }
        HgChangeset commit = (HgChangeset)changesets.get(0);
        return Commit.builder().buildTime(sdf.format(new Date())).buildAuthorName("").buildAuthorEmail("").branchName(commit.getBranch()).commitId(commit.getNodeid().toString()).commitTime(sdf.format(new Date(commit.getDate().getRawTime()))).commitUserName(HgSCMCommand.extractName(commit.getUser())).commitUserEmail(HgSCMCommand.extractEmail(commit.getUser())).commitMessage(commit.getComment().trim()).build();
    }

    private static String extractName(@NonNull String user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        int endIndex = user.indexOf(60) != -1 ? user.indexOf(60) : user.length();
        return user.substring(0, endIndex).trim();
    }

    private static String extractEmail(@NonNull String user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        int beginIndex = user.indexOf(60) + 1 < user.length() ? user.indexOf(60) + 1 : user.length();
        int endIndex = user.lastIndexOf(62) != -1 ? user.lastIndexOf(62) : user.length();
        return user.substring(beginIndex, endIndex).trim();
    }
}

