/*
 * Decompiled with CFR 0.152.
 */
package me.cmoz.gradle.snapshot;

import java.io.File;
import lombok.NonNull;
import me.cmoz.gradle.snapshot.SnapshotPluginExtension;
import me.cmoz.gradle.snapshot.SnapshotTask;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;

public final class SnapshotPlugin
implements Plugin<Project> {
    public static final String SNAPSHOT_TASK_NAME = "snapshot";

    public void apply(Project project) {
        SnapshotPluginExtension ext = (SnapshotPluginExtension)project.getExtensions().create(SNAPSHOT_TASK_NAME, SnapshotPluginExtension.class, new Object[0]);
        this.configureSnapshotTask(project, ext);
    }

    private void configureSnapshotTask(final @NonNull Project project, @NonNull SnapshotPluginExtension ext) {
        if (project == null) {
            throw new NullPointerException("project");
        }
        if (ext == null) {
            throw new NullPointerException("ext");
        }
        final TaskContainer tasks = project.getTasks();
        final SnapshotTask task = (SnapshotTask)tasks.create(SNAPSHOT_TASK_NAME, SnapshotTask.class);
        task.setDescription("Generate build information from an SCM repository.");
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin plugin) {
                File outputDir = new File(project.getBuildDir(), SnapshotPlugin.SNAPSHOT_TASK_NAME);
                SourceSetContainer sourceSets = (SourceSetContainer)project.getProperties().get("sourceSets");
                ((SourceSet)sourceSets.getByName("main")).getResources().srcDir((Object)outputDir);
                Task t = tasks.getByName("processResources");
                t.dependsOn(new Object[]{task});
            }
        });
    }
}

