/*
 * Decompiled with CFR 0.152.
 */
package me.cmoz.gradle.snapshot;

import java.io.File;
import java.io.FileWriter;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import me.cmoz.gradle.snapshot.GitSCMCommand;
import me.cmoz.gradle.snapshot.HgSCMCommand;
import me.cmoz.gradle.snapshot.SCMCommand;
import me.cmoz.gradle.snapshot.SnapshotPluginExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskAction;

public class SnapshotTask
extends DefaultTask {
    private static final String BUILD_LABEL = "Generated by the Gradle Snapshot Plugin (" + SnapshotTask.class.getPackage().getImplementationVersion() + ")";

    @TaskAction
    public void action() {
        ExtensionContainer extensions = this.getProject().getExtensions();
        SnapshotPluginExtension ext = (SnapshotPluginExtension)extensions.getByType(SnapshotPluginExtension.class);
        SCMCommand scmCmd = this.getSCMCommand();
        if (scmCmd == null) {
            System.out.println("  No supported SCM repository found, skipping task.");
            return;
        }
        Properties properties = new Properties();
        Map<String, String> commitMap = scmCmd.getLatestCommit(ext.getDateFormat()).asMap();
        for (Map.Entry<String, String> entry : commitMap.entrySet()) {
            extensions.getExtraProperties().set(entry.getKey(), (Object)entry.getValue());
            if (!ext.isVerbose()) continue;
            System.out.println("  " + entry);
        }
        properties.putAll(commitMap);
        File outputDir = new File(this.getProject().getBuildDir(), "snapshot");
        outputDir.mkdirs();
        File output = new File(outputDir, ext.getFilename());
        properties.store(new FileWriter(output), BUILD_LABEL);
    }

    @Nullable
    private SCMCommand getSCMCommand() {
        SCMCommand scmCmd = new HgSCMCommand(this.getProject());
        if (scmCmd.getRepositoryDir() != null) {
            return scmCmd;
        }
        scmCmd = new GitSCMCommand(this.getProject());
        if (scmCmd.getRepositoryDir() != null) {
            return scmCmd;
        }
        return null;
    }
}

