/*
 * Decompiled with CFR 0.152.
 */
package me.crypnotic.messagechannel.api.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.crypnotic.messagechannel.api.exception.MessageChannelException;

public class PipelineMessage {
    private final UUID target;
    private final List<Object> content;
    private int index;

    public PipelineMessage() {
        this(null);
    }

    public PipelineMessage(UUID target) {
        this(target, new ArrayList<Object>());
    }

    public PipelineMessage(UUID target, List<Object> content) {
        this.target = target;
        this.content = content;
        this.index = 0;
    }

    public void write(Object object) {
        this.content.add(object);
    }

    public Object read() throws MessageChannelException {
        if (this.index >= this.content.size()) {
            throw new MessageChannelException("List of size " + this.content.size() + " could not read object at " + this.index);
        }
        Object object = this.content.get(this.index);
        ++this.index;
        return object;
    }

    public <T> T read(Class<T> clazz) {
        Object object = this.read();
        if (object.getClass().isAssignableFrom(clazz)) {
            return clazz.cast(object);
        }
        throw new MessageChannelException("Could not cast " + object + " to class: " + clazz.getSimpleName());
    }

    public PipelineMessage clone() {
        return new PipelineMessage(this.target, this.content);
    }

    public List<Object> getContents() {
        return Collections.unmodifiableList(this.content);
    }

    public UUID getTarget() {
        return this.target;
    }
}

