/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.kato.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.ErrorDecoder;
import java.io.Reader;
import me.danwi.kato.client.exception.KatoClientException;
import me.danwi.kato.common.ExceptionResult;
import me.danwi.kato.common.exception.ExceptionExtraDataHolder;
import me.danwi.kato.common.exception.ExceptionIdentify;
import me.danwi.kato.common.exception.KatoException;
import org.springframework.http.HttpStatus;

public class KatoErrorDecoder
implements ErrorDecoder {
    private final ObjectMapper mapper = new ObjectMapper();

    public Exception decode(String methodKey, Response response) {
        if (response.status() != HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            return new ErrorDecoder.Default().decode(methodKey, response);
        }
        if (response.body() == null) {
            throw new DecodeException(response.status(), "\u65e0\u6cd5\u83b7\u53d6\u5f02\u5e38\u7684\u8be6\u7ec6\u4fe1\u606f", response.request());
        }
        try {
            String bodyStr = Util.toString((Reader)response.body().asReader(Util.UTF_8));
            ExceptionResult exceptionResult = (ExceptionResult)this.mapper.readValue(bodyStr, ExceptionResult.class);
            Exception exception = this.constructException(exceptionResult);
            if (exception == null) {
                return new KatoException(exceptionResult.getMessage());
            }
            if (!(exception instanceof RuntimeException)) {
                return new KatoException((Throwable)exception);
            }
            return exception;
        }
        catch (Exception e) {
            return new KatoClientException(e);
        }
    }

    private Exception constructException(ExceptionResult result) {
        block9: {
            try {
                Class<?> exceptionClass = Class.forName(result.getId());
                if (exceptionClass.getAnnotation(ExceptionIdentify.class) == null) break block9;
                Exception exceptionInstance = null;
                try {
                    exceptionInstance = (Exception)exceptionClass.getConstructor(String.class).newInstance(result.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (exceptionInstance == null) {
                    try {
                        exceptionInstance = (Exception)exceptionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (exceptionInstance == null) {
                    return null;
                }
                if (exceptionInstance instanceof ExceptionExtraDataHolder) {
                    ((ExceptionExtraDataHolder)exceptionInstance).loadFromMap(result.getData());
                }
                return exceptionInstance;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

