/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.apt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import me.danwi.sqlex.core.annotation.SqlExRepository;
import me.danwi.sqlex.core.annotation.method.SqlExPaged;
import me.danwi.sqlex.core.annotation.method.parameter.SqlExParameterCheck;
import me.danwi.sqlex.core.apt.SqlExProcessorUtil;

public class SqlExParameterCheckAnnotationProcessor
extends AbstractProcessor {
    private SqlExProcessorUtil util;
    private Types typesUtil;
    private Elements elementsUtil;
    private Messager messager;
    private final Map<String, List<String>> converters = new HashMap<String, List<String>>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.util = new SqlExProcessorUtil(processingEnv);
        this.typesUtil = processingEnv.getTypeUtils();
        this.elementsUtil = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        super.init(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add(SqlExParameterCheck.class.getName());
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> methods = roundEnv.getElementsAnnotatedWith(SqlExParameterCheck.class);
        for (Element element : methods) {
            try {
                if (!(element instanceof ExecutableElement)) continue;
                this.checkMethod((ExecutableElement)element);
            }
            catch (Exception e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, this.util.getQualifiedName(element) + ": " + e.getMessage());
            }
        }
        return true;
    }

    private synchronized List<String> getRegisteredTypes(TypeMirror repositoryType) throws Exception {
        List<String> registeredTypes = this.converters.get(this.util.getQualifiedName(repositoryType));
        if (registeredTypes == null) {
            Element repositoryElement = this.typesUtil.asElement(repositoryType);
            if (!(repositoryElement instanceof TypeElement)) {
                throw new Exception("\u8be5\u65b9\u6cd5\u6240\u5728\u7684Repository\u63a5\u53e3\u5f02\u5e38");
            }
            List<TypeElement> allParameterConverterElements = this.util.getAllParameterConverterElements((TypeElement)repositoryElement);
            ArrayList<String> fromTypes = new ArrayList<String>();
            for (TypeElement parameterConverterElement : allParameterConverterElements) {
                TypeMirror fromType = this.util.isValidateParameterConverter(parameterConverterElement);
                fromTypes.add(this.util.getQualifiedName(fromType));
            }
            this.converters.put(this.util.getQualifiedName(repositoryType), fromTypes);
            registeredTypes = fromTypes;
        }
        return registeredTypes;
    }

    private void checkMethod(ExecutableElement method) throws Exception {
        Element enclosingElement = method.getEnclosingElement();
        if (!(enclosingElement instanceof TypeElement)) {
            throw new Exception("\u8be5\u65b9\u6cd5\u4e0d\u5728\u4e00\u4e2a\u63a5\u53e3\u4e2d");
        }
        TypeElement interfaceElement = (TypeElement)enclosingElement;
        SqlExRepository repositoryAnnotation = interfaceElement.getAnnotation(SqlExRepository.class);
        TypeMirror repositoryType = null;
        try {
            repositoryAnnotation.value();
        }
        catch (MirroredTypeException e) {
            repositoryType = e.getTypeMirror();
        }
        if (repositoryType == null) {
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u8be5\u65b9\u6cd5\u6240\u5728\u7684repository");
        }
        List<String> registeredTypes = Collections.emptyList();
        try {
            registeredTypes = this.getRegisteredTypes(repositoryType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean isPagedMethod = method.getAnnotation(SqlExPaged.class) != null;
        for (VariableElement variableElement : method.getParameters()) {
            TypeMirror parameterType = variableElement.asType();
            if (isPagedMethod) {
                Name parameterName = variableElement.getSimpleName();
                if (parameterName.contentEquals("pageSize")) {
                    if (parameterType.getKind() == TypeKind.LONG) continue;
                    throw new Exception("pageSize\u53c2\u6570\u7684\u7c7b\u578b\u5fc5\u987b\u4e3along");
                }
                if (parameterName.contentEquals("pageNo")) {
                    if (parameterType.getKind() == TypeKind.LONG) continue;
                    throw new Exception("pageNo\u53c2\u6570\u7684\u7c7b\u578b\u5fc5\u987b\u4e3along");
                }
            }
            if (this.util.getQualifiedName(parameterType).contentEquals("java.util.List")) {
                parameterType = ((DeclaredType)parameterType).getTypeArguments().get(0);
            }
            if (this.util.isSupportedType(this.typesUtil.asElement(parameterType), registeredTypes)) continue;
            throw new Exception("\u53c2\u6570 " + variableElement.getSimpleName() + " \u4f7f\u7528\u4e86\u4e0d\u88ab\u652f\u6301\u7684\u53c2\u6570\u6570\u636e\u7c7b\u578b(" + this.util.getQualifiedName(parameterType) + ")");
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

