/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.annotation.entity.SqlExColumnName;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.jdbc.ParameterSetter;
import me.danwi.sqlex.core.jdbc.mapper.BasicTypeMapper;
import me.danwi.sqlex.core.query.InsertOption;
import me.danwi.sqlex.core.transaction.Transaction;
import me.danwi.sqlex.core.transaction.TransactionManager;
import org.jetbrains.annotations.Nullable;

public class TableInsert<T, K> {
    private final String tableName;
    private final BasicTypeMapper generatedColumnMapper;
    private final TransactionManager transactionManager;
    private final ParameterSetter parameterSetter;
    private final ExceptionTranslator translator;

    public TableInsert(String tableName, Class<K> generatedColumnJavaType, TransactionManager transactionManager, ParameterSetter parameterSetter, ExceptionTranslator translator) {
        this.tableName = tableName;
        this.generatedColumnMapper = generatedColumnJavaType == null ? null : new BasicTypeMapper(generatedColumnJavaType);
        this.transactionManager = transactionManager;
        this.parameterSetter = parameterSetter;
        this.translator = translator;
    }

    /*
     * Loose catch block
     */
    @Nullable
    public K insert(T entity, int options) {
        Transaction currentTransaction;
        LinkedList<String> columnNames = new LinkedList<String>();
        LinkedList<Object> parameters = new LinkedList<Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor property : propertyDescriptors = Introspector.getBeanInfo(entity.getClass()).getPropertyDescriptors()) {
                SqlExColumnName columnNameAnnotation;
                Method readMethod = property.getReadMethod();
                if (readMethod == null || (columnNameAnnotation = readMethod.getAnnotation(SqlExColumnName.class)) == null) continue;
                Object value = readMethod.invoke(entity, new Object[0]);
                if ((options & InsertOption.NULL_IS_NONE) == InsertOption.NULL_IS_NONE && value == null) continue;
                columnNames.add(columnNameAnnotation.value());
                parameters.add(value);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new SqlExImpossibleException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7684\u5c5e\u6027/\u5217\u4fe1\u606f", e);
        }
        String sql = String.format("insert into `%s`(%s) values(%s)", this.tableName, columnNames.stream().map(name -> "`" + name + "`").collect(Collectors.joining(", ")), columnNames.stream().map(it -> "?").collect(Collectors.joining(", ")));
        if ((options & InsertOption.INSERT_OR_UPDATE) == InsertOption.INSERT_OR_UPDATE) {
            sql = sql + " on duplicate key update " + columnNames.stream().map(it -> String.format("`%s` = values(`%s`)", it, it)).collect(Collectors.joining(","));
        }
        Connection connection = (currentTransaction = this.transactionManager.getCurrentTransaction()) != null ? currentTransaction.getConnection() : this.transactionManager.newConnection();
        try {
            K k;
            block33: {
                ResultSet rs;
                PreparedStatement statement;
                block30: {
                    Object obj;
                    block32: {
                        block31: {
                            List<?> fetchResult;
                            statement = connection.prepareStatement(sql, 1);
                            this.parameterSetter.setParameters(statement, parameters);
                            statement.executeUpdate();
                            rs = statement.getGeneratedKeys();
                            if (this.generatedColumnMapper == null || (fetchResult = this.generatedColumnMapper.fetch(rs)).size() <= 0) break block30;
                            obj = fetchResult.get(0);
                            if (rs == null) break block31;
                            rs.close();
                        }
                        if (statement == null) break block32;
                        statement.close();
                    }
                    return (K)obj;
                }
                try {
                    block34: {
                        if (rs != null) {
                            rs.close();
                        }
                        break block34;
                        {
                            catch (Throwable fetchResult) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable) {
                                        fetchResult.addSuppressed(throwable);
                                    }
                                }
                                throw fetchResult;
                            }
                        }
                    }
                    k = null;
                    if (statement == null) break block33;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw this.translator.translate(e);
                    }
                }
                statement.close();
            }
            return k;
        }
        finally {
            if (currentTransaction == null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw this.translator.translate(e);
                }
            }
        }
    }

    @Nullable
    public K insert(T entity) {
        return this.insert(entity, InsertOption.NONE_OPTIONS);
    }

    @Nullable
    public K insertWithoutNull(T entity) {
        return this.insert(entity, InsertOption.NULL_IS_NONE);
    }

    @Nullable
    public K upsert(T entity) {
        return this.insert(entity, InsertOption.INSERT_OR_UPDATE);
    }

    @Nullable
    public K upsertWithoutNull(T entity) {
        return this.insert(entity, InsertOption.NULL_IS_NONE | InsertOption.INSERT_OR_UPDATE);
    }
}

