/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.spring;

import java.sql.SQLException;
import javax.sql.DataSource;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.exception.SqlExUndeclaredException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;

public class SpringExceptionTranslator
implements ExceptionTranslator {
    private final SQLExceptionTranslator springTranslator;

    SpringExceptionTranslator(DataSource dataSource) {
        this.springTranslator = new SQLErrorCodeSQLExceptionTranslator(dataSource);
    }

    @Override
    public RuntimeException translate(Exception ex) {
        if (ex instanceof SQLException) {
            return this.springTranslator.translate("SqlEx", "", (SQLException)ex);
        }
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new SqlExUndeclaredException(ex);
    }
}

