/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.invoke.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.annotation.method.SqlExScript;
import me.danwi.sqlex.core.annotation.method.parameter.SqlExInExprPosition;
import me.danwi.sqlex.core.annotation.method.parameter.SqlExIsNullExprPosition;
import me.danwi.sqlex.core.annotation.method.parameter.SqlExMarkerPosition;
import me.danwi.sqlex.core.annotation.method.parameter.SqlExParameterPosition;
import me.danwi.sqlex.core.invoke.method.MethodProxy;
import me.danwi.sqlex.core.jdbc.ParameterSetter;
import me.danwi.sqlex.core.transaction.Transaction;
import me.danwi.sqlex.core.transaction.TransactionManager;

public abstract class BaseMethodProxy
implements MethodProxy {
    private final TransactionManager transactionManager;
    private final String sql;
    private final MarkerInfo[] markerInfos;
    protected final ParameterSetter parameterSetter;
    private final ExceptionTranslator translator;

    public BaseMethodProxy(Method method, TransactionManager transactionManager, ParameterSetter parameterSetter, ExceptionTranslator translator) {
        this.transactionManager = transactionManager;
        this.translator = translator;
        this.sql = method.getAnnotation(SqlExScript.class).value();
        this.parameterSetter = parameterSetter;
        int[] markerPositions = method.getAnnotation(SqlExMarkerPosition.class).value();
        int[] parameterPositions = method.getAnnotation(SqlExParameterPosition.class).value();
        SqlExInExprPosition[] inExprPositions = (SqlExInExprPosition[])method.getAnnotationsByType(SqlExInExprPosition.class);
        SqlExIsNullExprPosition[] isNullExprPositions = (SqlExIsNullExprPosition[])method.getAnnotationsByType(SqlExIsNullExprPosition.class);
        this.markerInfos = new MarkerInfo[markerPositions.length];
        for (int index = 0; index < markerPositions.length; ++index) {
            MarkerInfo markerInfo = new MarkerInfo();
            int sqlIndex = markerPositions[index];
            for (SqlExInExprPosition sqlExInExprPosition : inExprPositions) {
                if (sqlExInExprPosition.marker() != sqlIndex) continue;
                markerInfo.inExprPosition = sqlExInExprPosition;
                break;
            }
            for (Annotation annotation : isNullExprPositions) {
                if (annotation.marker() != sqlIndex) continue;
                markerInfo.isNullExprPosition = annotation;
                break;
            }
            markerInfo.argIndex = parameterPositions[index];
            this.markerInfos[index] = markerInfo;
        }
    }

    protected List<Object> reorderArgs(Object[] methodArgs) {
        ArrayList<Object> reorderArgs = new ArrayList<Object>(this.markerInfos.length);
        for (MarkerInfo markerInfo : this.markerInfos) {
            Object methodArg = methodArgs[markerInfo.argIndex];
            if (markerInfo.inExprPosition != null) {
                if (methodArg == null) continue;
                if (methodArg instanceof List) {
                    List listArg = (List)methodArg;
                    if (listArg.size() == 0) continue;
                    reorderArgs.addAll(listArg);
                    continue;
                }
                reorderArgs.add(methodArg);
                continue;
            }
            if (markerInfo.isNullExprPosition != null) continue;
            reorderArgs.add(methodArg);
        }
        return reorderArgs;
    }

    protected String rewriteSQL(Object[] methodArgs) {
        LinkedList<RewriteInfo> rewriteInfos = new LinkedList<RewriteInfo>();
        for (MarkerInfo markerInfo : this.markerInfos) {
            Object methodArg = methodArgs[markerInfo.argIndex];
            if (markerInfo.inExprPosition != null) {
                if (methodArg == null) {
                    rewriteInfos.add(new RewriteInfo(markerInfo.inExprPosition.start(), markerInfo.inExprPosition.end(), markerInfo.inExprPosition.not() ? "1=1" : "1=2"));
                } else if (methodArg instanceof List) {
                    List listArg = (List)methodArg;
                    if (listArg.size() == 0) {
                        rewriteInfos.add(new RewriteInfo(markerInfo.inExprPosition.start(), markerInfo.inExprPosition.end(), markerInfo.inExprPosition.not() ? "1=1" : "1=2"));
                    } else {
                        String markerPart = listArg.stream().map(it -> "?").collect(Collectors.joining(","));
                        rewriteInfos.add(new RewriteInfo(markerInfo.inExprPosition.marker(), markerInfo.inExprPosition.marker() + 1, markerPart));
                    }
                }
            }
            if (markerInfo.isNullExprPosition == null) continue;
            boolean argIsNull = methodArg == null;
            boolean sqlIsNull = !markerInfo.isNullExprPosition.not();
            rewriteInfos.add(new RewriteInfo(markerInfo.isNullExprPosition.start(), markerInfo.isNullExprPosition.end(), argIsNull == sqlIsNull ? "1=1" : "1=2"));
        }
        StringBuilder rewrittenSQL = new StringBuilder(this.sql);
        while (!rewriteInfos.isEmpty()) {
            RewriteInfo rewriteInfo = (RewriteInfo)rewriteInfos.remove(0);
            rewrittenSQL.replace(rewriteInfo.start, rewriteInfo.end, rewriteInfo.content);
            int sizeGrow = rewriteInfo.content.length() - (rewriteInfo.end - rewriteInfo.start);
            rewriteInfos.forEach(info -> {
                if (info.start >= rewriteInfo.end) {
                    info.start += sizeGrow;
                    info.end += sizeGrow;
                }
            });
        }
        return rewrittenSQL.toString();
    }

    @Override
    public Object invoke(Object[] args) {
        Transaction currentTransaction = this.transactionManager.getCurrentTransaction();
        Connection connection = currentTransaction != null ? currentTransaction.getConnection() : this.transactionManager.newConnection();
        try {
            Object object = this.invoke(args, connection);
            return object;
        }
        catch (SQLException e) {
            throw this.translator.translate(e);
        }
        finally {
            if (currentTransaction == null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw this.translator.translate(e);
                }
            }
        }
    }

    protected abstract Object invoke(Object[] var1, Connection var2) throws SQLException;

    private static class RewriteInfo {
        public int start;
        public int end;
        public String content;

        public RewriteInfo(int start, int end, String content) {
            this.start = start;
            this.end = end;
            this.content = content;
        }
    }

    private static class MarkerInfo {
        public int argIndex;
        public SqlExInExprPosition inExprPosition;
        public SqlExIsNullExprPosition isNullExprPosition;

        private MarkerInfo() {
        }
    }
}

