/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.jdbc;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.danwi.sqlex.core.RepositoryLike;
import me.danwi.sqlex.core.annotation.repository.SqlExConverter;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.type.ParameterConverter;

public class ParameterSetter {
    private final Map<Class<?>, ParameterConverter<Object, Object>> parameterConverters;

    private ParameterSetter(Map<Class<?>, ParameterConverter<Object, Object>> parameterConverters) {
        this.parameterConverters = parameterConverters;
    }

    public static ParameterSetter fromRepository(Class<? extends RepositoryLike> repository) {
        SqlExConverter[] converterAnnotations;
        HashMap parameterConverters = new HashMap();
        for (SqlExConverter converterAnnotation : converterAnnotations = (SqlExConverter[])repository.getAnnotationsByType(SqlExConverter.class)) {
            Type[] converterInterfaces;
            Class<?> converter = converterAnnotation.converter();
            for (Type converterInterface : converterInterfaces = converter.getGenericInterfaces()) {
                ParameterConverter instance;
                Type[] typeArguments;
                ParameterizedType parameterizedType;
                if (!(converterInterface instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)converterInterface).getRawType().getTypeName().equals(ParameterConverter.class.getTypeName()) || (typeArguments = parameterizedType.getActualTypeArguments()).length != 2 || !(typeArguments[0] instanceof Class)) continue;
                try {
                    instance = (ParameterConverter)converter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new SqlExImpossibleException("\u65e0\u6cd5\u5b9e\u4f8b\u5316\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5668");
                }
                parameterConverters.put((Class)typeArguments[0], instance);
            }
        }
        return new ParameterSetter(parameterConverters);
    }

    private ParameterConverter<Object, Object> getConverterFor(Object parameter) {
        for (Map.Entry<Class<?>, ParameterConverter<Object, Object>> converterEntry : this.parameterConverters.entrySet()) {
            if (!converterEntry.getKey().isInstance(parameter)) continue;
            return converterEntry.getValue();
        }
        return null;
    }

    public void setParameter(PreparedStatement statement, int index, Object arg) throws SQLException {
        if (arg == null) {
            statement.setNull(index, 0);
            return;
        }
        if (arg instanceof Boolean) {
            statement.setBoolean(index, (Boolean)arg);
            return;
        }
        if (arg instanceof Byte) {
            statement.setByte(index, (Byte)arg);
            return;
        }
        if (arg instanceof Short) {
            statement.setShort(index, (Short)arg);
            return;
        }
        if (arg instanceof Integer) {
            statement.setInt(index, (Integer)arg);
            return;
        }
        if (arg instanceof Long) {
            statement.setLong(index, (Long)arg);
            return;
        }
        if (arg instanceof Float) {
            statement.setFloat(index, ((Float)arg).floatValue());
            return;
        }
        if (arg instanceof Double) {
            statement.setDouble(index, (Double)arg);
            return;
        }
        if (arg instanceof Character) {
            statement.setString(index, arg.toString());
            return;
        }
        if (arg instanceof String) {
            statement.setString(index, (String)arg);
            return;
        }
        if (arg instanceof BigInteger) {
            statement.setBigDecimal(index, new BigDecimal((BigInteger)arg));
            return;
        }
        if (arg instanceof BigDecimal) {
            statement.setBigDecimal(index, (BigDecimal)arg);
            return;
        }
        if (arg instanceof byte[]) {
            statement.setBytes(index, (byte[])arg);
            return;
        }
        if (arg instanceof Blob) {
            statement.setBlob(index, (Blob)arg);
            return;
        }
        if (arg instanceof Date) {
            statement.setDate(index, (Date)arg);
            return;
        }
        if (arg instanceof Time) {
            statement.setTime(index, (Time)arg);
            return;
        }
        if (arg instanceof Timestamp) {
            statement.setTimestamp(index, (Timestamp)arg);
            return;
        }
        if (arg instanceof java.util.Date) {
            statement.setTimestamp(index, new Timestamp(((java.util.Date)arg).getTime()));
            return;
        }
        if (arg instanceof LocalDate || arg instanceof LocalTime || arg instanceof LocalDateTime || arg instanceof OffsetTime || arg instanceof OffsetDateTime || arg instanceof ZonedDateTime) {
            statement.setObject(index, arg);
            return;
        }
        if (arg instanceof Instant) {
            statement.setTimestamp(index, Timestamp.from((Instant)arg));
            return;
        }
        ParameterConverter<Object, Object> converter = this.getConverterFor(arg);
        if (converter != null) {
            Object convertedArg = converter.convert(arg);
            this.setParameter(statement, index, convertedArg);
            return;
        }
        throw new SqlExImpossibleException("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u6570\u636e\u7c7b\u578b");
    }

    public void setParameters(PreparedStatement statement, List<Object> args) throws SQLException {
        for (int i = 0; i < args.size(); ++i) {
            this.setParameter(statement, i + 1, args.get(i));
        }
    }
}

