/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.apt;

import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import me.danwi.sqlex.core.annotation.repository.SqlExAPTChecked;

public class SqlExAPTCheckedAnnotationProcessor
extends AbstractProcessor {
    public static String CheckedStubClassName = "IfThisClassUndefinedPleaseCheckAPTConfig";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> repositoryClasses = roundEnv.getElementsAnnotatedWith(SqlExAPTChecked.class);
        for (Element element : repositoryClasses) {
            if (!(element instanceof TypeElement)) continue;
            this.generateCheckStub((TypeElement)element);
        }
        return false;
    }

    private void generateCheckStub(TypeElement repositoryClass) {
        Element enclosingElement = repositoryClass.getEnclosingElement();
        if (!(enclosingElement instanceof PackageElement)) {
            return;
        }
        String rootPackage = ((PackageElement)enclosingElement).getQualifiedName().toString();
        try {
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(rootPackage + "." + CheckedStubClassName, new Element[0]);
            try (Writer writer = sourceFile.openWriter();){
                writer.write("package " + rootPackage + ";\n\nclass " + CheckedStubClassName + "{}");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add(SqlExAPTChecked.class.getName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

