/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core;

import com.mysql.cj.jdbc.MysqlConnectionPoolDataSource;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.RepositoryLike;
import me.danwi.sqlex.core.TransactionAction;
import me.danwi.sqlex.core.TransactionActionReturnVoid;
import me.danwi.sqlex.core.annotation.SqlExDataAccessObject;
import me.danwi.sqlex.core.annotation.SqlExRepository;
import me.danwi.sqlex.core.annotation.SqlExTableAccessObject;
import me.danwi.sqlex.core.checker.Checker;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.exception.SqlExRepositoryNotMatchException;
import me.danwi.sqlex.core.exception.SqlExSQLException;
import me.danwi.sqlex.core.exception.SqlExUndeclaredException;
import me.danwi.sqlex.core.invoke.InvocationProxy;
import me.danwi.sqlex.core.jdbc.ParameterSetter;
import me.danwi.sqlex.core.migration.Migrator;
import me.danwi.sqlex.core.transaction.DefaultTransactionManager;
import me.danwi.sqlex.core.transaction.Transaction;
import me.danwi.sqlex.core.transaction.TransactionManager;

public class DaoFactory {
    private final Class<?> repositoryClass;
    private final TransactionManager transactionManager;
    private final ParameterSetter parameterSetter;
    private final Map<Class<?>, InvocationProxy> invocationProxyCache = new HashMap();
    private final ExceptionTranslator exceptionTranslator;
    private final Migrator migrator;
    private final Checker checker;

    public DaoFactory(String url, String username, String password, Class<? extends RepositoryLike> repository) {
        MysqlConnectionPoolDataSource dataSource = new MysqlConnectionPoolDataSource();
        dataSource.setURL(url);
        dataSource.setUser(username);
        dataSource.setPassword(password);
        this.repositoryClass = repository;
        this.exceptionTranslator = new DefaultExceptionTranslator();
        this.transactionManager = new DefaultTransactionManager((DataSource)dataSource, this.exceptionTranslator);
        this.parameterSetter = ParameterSetter.fromRepository(repository);
        this.migrator = new Migrator(this);
        this.checker = new Checker(this);
    }

    public DaoFactory(DataSource dataSource, Class<? extends RepositoryLike> repository) {
        this.repositoryClass = repository;
        this.exceptionTranslator = new DefaultExceptionTranslator();
        this.transactionManager = new DefaultTransactionManager(dataSource, this.exceptionTranslator);
        this.parameterSetter = ParameterSetter.fromRepository(repository);
        this.migrator = new Migrator(this);
        this.checker = new Checker(this);
    }

    public DaoFactory(TransactionManager transactionManager, Class<? extends RepositoryLike> repository, ExceptionTranslator exceptionTranslator) {
        this.repositoryClass = repository;
        this.transactionManager = transactionManager;
        this.parameterSetter = ParameterSetter.fromRepository(repository);
        this.exceptionTranslator = exceptionTranslator;
        this.migrator = new Migrator(this);
        this.checker = new Checker(this);
    }

    public Transaction newTransaction() {
        return this.transactionManager.newTransaction();
    }

    public <T> T transaction(TransactionAction<T> action) {
        return this.transaction(this.transactionManager.getDefaultIsolationLevel(), action);
    }

    public void transaction(TransactionActionReturnVoid action) {
        this.transaction(this.transactionManager.getDefaultIsolationLevel(), action);
    }

    public void transaction(Integer transactionIsolationLevel, TransactionActionReturnVoid action) {
        this.transaction(transactionIsolationLevel, (Transaction transaction) -> {
            action.run(transaction);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T transaction(Integer transactionIsolationLevel, TransactionAction<T> action) {
        Transaction currentTransaction = this.transactionManager.getCurrentTransaction();
        boolean isTopLevelTransaction = false;
        if (currentTransaction == null) {
            isTopLevelTransaction = true;
            currentTransaction = this.transactionManager.newTransaction(transactionIsolationLevel);
        }
        RuntimeException exception = null;
        try {
            T t = action.run(currentTransaction);
            return t;
        }
        catch (Exception e) {
            exception = this.exceptionTranslator.translate(e);
            throw exception;
        }
        finally {
            if (isTopLevelTransaction) {
                block20: {
                    try {
                        if (exception == null) {
                            currentTransaction.commit();
                            break block20;
                        }
                        currentTransaction.rollback();
                    }
                    catch (Throwable throwable) {
                        try {
                            currentTransaction.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {
                    currentTransaction.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Connection newConnection() {
        return this.transactionManager.newConnection();
    }

    public Class<?> getRepositoryClass() {
        return this.repositoryClass;
    }

    public ExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public void migrate() {
        this.migrator.migrate();
    }

    public void check() {
        this.checker.check();
    }

    public <T> T getInstance(Class<T> clazz) {
        if (clazz.isAnnotationPresent(SqlExDataAccessObject.class)) {
            return this.getDaoInstance(clazz);
        }
        if (clazz.isAnnotationPresent(SqlExTableAccessObject.class)) {
            return this.getTableInstance(clazz);
        }
        throw new SqlExRepositoryNotMatchException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D> D getDaoInstance(Class<D> dao) {
        InvocationProxy invocationProxy = this.invocationProxyCache.get(dao);
        if (invocationProxy == null) {
            Map<Class<?>, InvocationProxy> map = this.invocationProxyCache;
            synchronized (map) {
                invocationProxy = this.invocationProxyCache.get(dao);
                if (invocationProxy == null) {
                    SqlExRepository annotation = dao.getAnnotation(SqlExRepository.class);
                    if (annotation == null) {
                        throw new SqlExRepositoryNotMatchException();
                    }
                    if (!annotation.value().getName().equals(this.repositoryClass.getName())) {
                        throw new SqlExRepositoryNotMatchException();
                    }
                    invocationProxy = new InvocationProxy(this.transactionManager, this.parameterSetter, this.exceptionTranslator);
                    this.invocationProxyCache.put(dao, invocationProxy);
                }
            }
        }
        return (D)Proxy.newProxyInstance(dao.getClassLoader(), new Class[]{dao}, (InvocationHandler)invocationProxy);
    }

    private <T> T getTableInstance(Class<T> table) {
        SqlExRepository annotation = table.getAnnotation(SqlExRepository.class);
        if (annotation == null) {
            throw new SqlExRepositoryNotMatchException();
        }
        if (!annotation.value().getName().equals(this.repositoryClass.getName())) {
            throw new SqlExRepositoryNotMatchException();
        }
        try {
            Constructor<T> constructor = table.getConstructor(TransactionManager.class, ParameterSetter.class, ExceptionTranslator.class);
            return constructor.newInstance(this.transactionManager, this.parameterSetter, this.exceptionTranslator);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SqlExImpossibleException("\u65e0\u6cd5\u5b9e\u4f8b\u5316\u8868\u64cd\u4f5c\u5bf9\u8c61", e);
        }
    }

    static class DefaultExceptionTranslator
    implements ExceptionTranslator {
        DefaultExceptionTranslator() {
        }

        @Override
        public RuntimeException translate(Exception ex) {
            if (ex instanceof SQLException) {
                return new SqlExSQLException((SQLException)ex);
            }
            if (ex instanceof RuntimeException) {
                return (RuntimeException)ex;
            }
            return new SqlExUndeclaredException(ex);
        }
    }
}

