/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.jdbc.ParameterSetter;
import me.danwi.sqlex.core.jdbc.mapper.BeanMapper;
import me.danwi.sqlex.core.jdbc.mapper.RowMapper;
import me.danwi.sqlex.core.query.Order;
import me.danwi.sqlex.core.query.SQLParameterBind;
import me.danwi.sqlex.core.query.WhereBuilder;
import me.danwi.sqlex.core.query.expression.Expression;
import me.danwi.sqlex.core.query.expression.ExpressionUtil;
import me.danwi.sqlex.core.transaction.TransactionManager;
import me.danwi.sqlex.core.type.PagedResult;
import org.jetbrains.annotations.Nullable;

public class TableQuery<T>
extends WhereBuilder<TableQuery<T>> {
    private final String tableName;
    private final TransactionManager transactionManager;
    private final ParameterSetter parameterSetter;
    private final RowMapper rowMapper;
    private final ExceptionTranslator translator;
    private final List<OrderPair> orders = new ArrayList<OrderPair>();
    private Long skip;
    private Long take;
    private boolean forUpdate = false;

    public TableQuery(String tableName, TransactionManager transactionManager, ParameterSetter parameterSetter, ExceptionTranslator translator, Class<T> entityClass) {
        this.tableName = tableName;
        this.transactionManager = transactionManager;
        this.parameterSetter = parameterSetter;
        this.rowMapper = new BeanMapper(entityClass);
        this.translator = translator;
    }

    public TableQuery<T> order(Expression exp) {
        return this.order(exp, Order.Asc);
    }

    public TableQuery<T> order(Expression exp, Order order) {
        OrderPair pair = new OrderPair();
        pair.expression = exp;
        pair.order = order;
        this.orders.add(pair);
        return this;
    }

    public TableQuery<T> skip(long number) {
        this.skip = number;
        return this;
    }

    public TableQuery<T> take(long number) {
        this.take = number;
        return this;
    }

    public TableQuery<T> forUpdate() {
        this.forUpdate = true;
        return this;
    }

    private SQLParameterBind buildSQL() {
        String sql = "select * from `" + this.tableName + "`";
        LinkedList<Object> parameters = new LinkedList<Object>();
        if (this.whereCondition != null) {
            SQLParameterBind sqlParameterBind = ExpressionUtil.toSQL(this.whereCondition);
            sql = sql + " where " + sqlParameterBind.getSQL();
            parameters.addAll(sqlParameterBind.getParameters());
        }
        if (!this.orders.isEmpty()) {
            sql = sql + " order by ";
            LinkedList<String> orderSegments = new LinkedList<String>();
            for (OrderPair order : this.orders) {
                SQLParameterBind sqlParameterBind = ExpressionUtil.toSQL(order.expression);
                orderSegments.add("(" + sqlParameterBind.getSQL() + ") " + (order.order == Order.Asc ? "asc" : "desc"));
                parameters.addAll(sqlParameterBind.getParameters());
            }
            sql = sql + String.join((CharSequence)", ", orderSegments);
        }
        if (this.skip != null && this.take != null) {
            sql = sql + String.format(" limit %d, %d", this.skip, this.take);
        } else if (this.skip != null) {
            sql = sql + String.format(" limit %d, 18446744073709551615", this.skip);
        } else if (this.take != null) {
            sql = sql + " limit " + this.take;
        }
        if (this.forUpdate) {
            sql = sql + " for update";
        }
        return new SQLParameterBind(sql, parameters);
    }

    /*
     * Exception decompiling
     */
    public long count() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<T> find() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public T findOne() {
        List<T> results = this.take(1L).find();
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public PagedResult<T> page(long pageSize, long pageNo) {
        long total = this.count();
        this.skip(pageSize * (pageNo - 1L)).take(pageSize);
        List<T> data = this.find();
        return new PagedResult<T>(pageSize, pageNo, total, data);
    }

    private static class OrderPair {
        Expression expression;
        Order order;

        private OrderPair() {
        }
    }
}

