/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query.expression;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import me.danwi.sqlex.core.query.expression.Expression;
import me.danwi.sqlex.core.query.expression.NotVariantExpression;

public class InExpression
implements NotVariantExpression {
    private final Expression expression;
    private final List<Expression> set;

    public InExpression(Expression expression, Iterable<Expression> set) {
        this.expression = expression;
        this.set = StreamSupport.stream(set.spliterator(), false).collect(Collectors.toList());
    }

    @Override
    public String toSQL() {
        if (this.set.size() == 0) {
            return "1 = 2";
        }
        return String.format("%s in (%s)", this.expression.toSQL(), this.set.stream().map(Expression::toSQL).collect(Collectors.joining(", ")));
    }

    @Override
    public String toNotSQL() {
        if (this.set.size() == 0) {
            return "1 = 1";
        }
        return String.format("%s not in (%s)", this.expression.toSQL(), this.set.stream().map(Expression::toSQL).collect(Collectors.joining(", ")));
    }
}

